"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMEmbeddableRoot = APMEmbeddableRoot;
var _react = _interopRequireDefault(require("react"));
var _uuid = require("uuid");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/embeddable-plugin/public");
var _sloSchema = require("@kbn/slo-schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/alert_details/components/custom_panels/apm/embeddable_root.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function APMEmbeddableRoot({
  slo,
  dataTimeRange,
  embeddableId,
  alert,
  rule
}) {
  const filter = slo.indicator.params.filter;
  const isKueryFilter = typeof filter === 'string';
  const groupingInput = getInputFromGroupings(slo);
  const indicator = slo.indicator;
  const kuery = isKueryFilter ? filter : undefined;
  const allFilters = !isKueryFilter && filter !== null && filter !== void 0 && filter.filters ? [...(filter === null || filter === void 0 ? void 0 : filter.filters), ...groupingInput.filters] : groupingInput.filters;
  const filters = (0, _esQuery.buildQueryFromFilters)(allFilters, undefined, undefined);
  const groupingsInput = getInputFromGroupings(slo);
  const {
    transactionName,
    transactionType,
    environment,
    service
  } = indicator.params;
  const input = {
    id: (0, _uuid.v4)(),
    serviceName: service,
    transactionName: transactionName !== '*' ? transactionName : undefined,
    transactionType: transactionType !== '*' ? transactionType : undefined,
    environment: environment !== '*' ? environment : undefined,
    rangeFrom: dataTimeRange.from.toISOString(),
    rangeTo: dataTimeRange.to.toISOString(),
    latencyThresholdInMicroseconds: _sloSchema.apmTransactionDurationIndicatorSchema.is(indicator) ? indicator.params.threshold * 1000 : undefined,
    kuery,
    filters,
    alert,
    rule,
    comparisonEnabled: true,
    offset: '1d',
    ...groupingsInput.input
  };
  if (!input.serviceName || !input.transactionType) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_public.EmbeddableRenderer, {
    type: embeddableId,
    getParentApi: () => ({
      getSerializedStateForChild: () => ({
        rawState: input
      })
    }),
    hidePanelChrome: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  });
}
const getInputFromGroupings = slo => {
  const groupings = Object.entries(slo.groupings);
  const input = {};
  const filters = [];
  groupings.forEach(([key, value]) => {
    switch (key) {
      case 'transaction.name':
        input.transactionName = value;
        break;
      case 'transaction.type':
        input.transactionType = value;
        break;
      case 'service.name':
        input.serviceName = value;
        break;
      case 'service.environment':
        input.environment = value;
        break;
      default:
        filters.push({
          meta: {
            type: 'custom',
            alias: null,
            key,
            params: {
              query: value
            },
            disabled: false
          },
          query: {
            match_phrase: {
              [key]: value
            }
          }
        });
    }
  });
  return {
    input,
    filters
  };
};