"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaSectionErrorBoundary = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _apmRum = require("@elastic/apm-rum");
var _lib = require("../../lib");
var _services = require("../services");
var _message_components = require("./message_components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/shared-ux/error_boundary/src/ui/section_error_boundary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * `KibanaSectionErrorBoundary` is designed to capture errors at a granular level.
 *
 * In general, it's best to use `KibanaErrorBoundary` and block the whole page.
 * Users will see an error state on the page and think that there are instabilities in the system.
 * They will be / should be wary about making any changes in a UI showing an error, since it risks
 * further instability.
 *
 * If it is acceptable to assume the risk of allowing users to interact with a UI that
 * has an error state, then using `KibanaSectionErrorBoundary` may be an acceptable alternative,
 * but this must be judged on a case-by-case basis.
 */
const KibanaSectionErrorBoundary = props => {
  const services = (0, _services.useErrorBoundary)();
  return /*#__PURE__*/_react.default.createElement(SectionErrorBoundaryInternal, (0, _extends2.default)({}, props, {
    services: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 10
    }
  }));
};
exports.KibanaSectionErrorBoundary = KibanaSectionErrorBoundary;
class SectionErrorBoundaryInternal extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null,
      errorInfo: null,
      componentName: null,
      isFatal: null
    };
  }
  componentDidCatch(error, errorInfo) {
    _apmRum.apm.captureError(error, {
      labels: (0, _lib.getErrorBoundaryLabels)('SectionFatalReactError')
    });
    console.error('Error caught by Kibana React Error Boundary'); // eslint-disable-line no-console
    console.error(error); // eslint-disable-line no-console

    const {
      name,
      isFatal
    } = this.props.services.errorService.registerError(error, errorInfo);
    this.setState({
      error,
      errorInfo,
      componentName: name,
      isFatal
    });
  }
  render() {
    if (!this.state.error) {
      return this.props.children;
    }
    const {
      error,
      errorInfo,
      componentName,
      isFatal
    } = this.state;
    if (isFatal) {
      return /*#__PURE__*/_react.default.createElement(_message_components.SectionFatalPrompt, {
        sectionName: this.props.sectionName,
        error: error,
        errorInfo: errorInfo,
        name: componentName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_message_components.SectionRecoverablePrompt, {
      sectionName: this.props.sectionName,
      onClickRefresh: this.props.services.onClickRefresh,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 7
      }
    });
  }
}