"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reactFatalErrorSchema = exports.REACT_FATAL_ERROR_EVENT_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
const REACT_FATAL_ERROR_EVENT_TYPE = exports.REACT_FATAL_ERROR_EVENT_TYPE = 'fatal-error-react';

/** @internal */

/** @internal */
const reactFatalErrorSchema = exports.reactFatalErrorSchema = {
  component_name: {
    type: 'keyword',
    _meta: {
      description: 'Name of react component that threw an error',
      optional: false
    }
  },
  component_stack: {
    type: 'text',
    _meta: {
      description: 'Stack trace React component tree',
      optional: false
    }
  },
  error_message: {
    type: 'keyword',
    _meta: {
      description: 'Message from the error',
      optional: false
    }
  },
  error_stack: {
    type: 'text',
    _meta: {
      description: 'Stack trace from the error object',
      optional: false
    }
  }
};