"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbedContent = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _url = require("url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/share/public/components/tabs/embed/embed_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EmbedContent = ({
  shareableUrlForSavedObject,
  shareableUrl,
  shareableUrlLocatorParams,
  objectType,
  objectConfig = {},
  isDirty,
  allowShortUrl,
  shortUrlService,
  anonymousAccess
}) => {
  const urlParamsRef = (0, _react.useRef)(undefined);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [snapshotUrl, setSnapshotUrl] = (0, _react.useState)('');
  const [isTextCopied, setTextCopied] = (0, _react.useState)(false);
  const urlToCopy = (0, _react.useRef)(undefined);
  const [anonymousAccessParameters, setAnonymousAccessParameters] = (0, _react.useState)(null);
  const [usePublicUrl, setUsePublicUrl] = (0, _react.useState)(false);
  const [showPublicUrlSwitch, setShowPublicUrlSwitch] = (0, _react.useState)(false);
  const copiedTextToolTipCleanupIdRef = (0, _react.useRef)();
  const {
    draftModeCallOut: DraftModeCallout,
    computeAnonymousCapabilities,
    embedUrlParamExtensions: urlParamExtensions
  } = objectConfig;
  (0, _react.useEffect)(() => {
    if (computeAnonymousCapabilities && anonymousAccess) {
      const resolveAnonymousAccessClaims = async () => {
        try {
          const [state, capabilities] = await Promise.all([anonymousAccess.getState(), anonymousAccess.getCapabilities()]);
          if (state !== null && state !== void 0 && state.isEnabled) {
            setAnonymousAccessParameters(state === null || state === void 0 ? void 0 : state.accessURLParameters);
            if (capabilities) {
              setShowPublicUrlSwitch(computeAnonymousCapabilities === null || computeAnonymousCapabilities === void 0 ? void 0 : computeAnonymousCapabilities(capabilities));
            }
          }
        } catch {
          //
        }
      };
      resolveAnonymousAccessClaims();
    }
  }, [anonymousAccess, computeAnonymousCapabilities]);
  const makeUrlEmbeddable = (0, _react.useCallback)(tempUrl => {
    const embedParam = '?embed=true';
    const urlHasQueryString = tempUrl.indexOf('?') !== -1;
    if (urlHasQueryString) {
      return tempUrl.replace('?', `${embedParam}&`);
    }
    return `${tempUrl}${embedParam}`;
  }, []);
  const getUrlParamExtensions = (0, _react.useCallback)(tempUrl => {
    const urlWithUpdatedParams = urlParamsRef.current ? Object.keys(urlParamsRef.current).reduce((urlAccumulator, key) => {
      var _urlParamsRef$current;
      const urlParam = (_urlParamsRef$current = urlParamsRef.current) === null || _urlParamsRef$current === void 0 ? void 0 : _urlParamsRef$current[key];
      return urlParam ? Object.keys(urlParam).reduce((queryAccumulator, queryParam) => {
        const isQueryParamEnabled = urlParam[queryParam];
        return isQueryParamEnabled ? queryAccumulator + `&${queryParam}=true` : queryAccumulator;
      }, urlAccumulator) : urlAccumulator;
    }, tempUrl) : tempUrl;
    return urlWithUpdatedParams;
  }, []);
  const updateUrlParams = (0, _react.useCallback)(url => getUrlParamExtensions(makeUrlEmbeddable(url)), [makeUrlEmbeddable, getUrlParamExtensions]);
  (0, _react.useEffect)(() => setSnapshotUrl(updateUrlParams(shareableUrl || window.location.href)), [shareableUrl, updateUrlParams]);
  const getSavedObjectUrl = (0, _react.useCallback)(() => {
    const tempUrl = shareableUrlForSavedObject ? updateUrlParams(shareableUrlForSavedObject) : snapshotUrl;
    const parsedUrl = (0, _url.parse)(tempUrl);
    if (!parsedUrl || !parsedUrl.hash) {
      return tempUrl;
    }

    // Get the application route, after the hash, and remove the #.
    const parsedAppUrl = (0, _url.parse)(parsedUrl.hash.slice(1), true);
    const formattedUrl = (0, _url.format)({
      protocol: parsedUrl.protocol,
      auth: parsedUrl.auth,
      host: parsedUrl.host,
      pathname: parsedUrl.pathname,
      hash: (0, _url.format)({
        pathname: parsedAppUrl.pathname,
        query: {
          // Add global state to the URL so that the iframe doesn't just show the time range
          // default.
          _g: parsedAppUrl.query._g
        }
      })
    });
    return updateUrlParams(formattedUrl);
  }, [shareableUrlForSavedObject, snapshotUrl, updateUrlParams]);
  const createShortUrl = (0, _react.useCallback)(async () => {
    if (shareableUrlLocatorParams) {
      const shortUrl = await shortUrlService.createWithLocator(shareableUrlLocatorParams);
      return shortUrl.locator.getUrl(shortUrl.params, {
        absolute: true
      });
    } else {
      return (await shortUrlService.createFromLongUrl(snapshotUrl)).url;
    }
  }, [shareableUrlLocatorParams, snapshotUrl, shortUrlService]);
  const addUrlAnonymousAccessParameters = (0, _react.useCallback)(tempUrl => {
    if (!anonymousAccessParameters || !usePublicUrl) {
      return tempUrl;
    }
    const parsedUrl = new URL(tempUrl);
    for (const [name, value] of Object.entries(anonymousAccessParameters)) {
      parsedUrl.searchParams.set(name, value);
    }
    return parsedUrl.toString();
  }, [anonymousAccessParameters, usePublicUrl]);
  const getEmbedLink = (0, _react.useCallback)(async () => {
    const embedUrl = addUrlAnonymousAccessParameters(!isDirty ? getSavedObjectUrl() : allowShortUrl ? await createShortUrl() : snapshotUrl);
    return `<iframe src="${embedUrl}" height="600" width="800"></iframe>`;
  }, [addUrlAnonymousAccessParameters, allowShortUrl, createShortUrl, getSavedObjectUrl, isDirty, snapshotUrl]);
  const copyUrlHelper = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    urlToCopy.current = await getEmbedLink();
    (0, _eui.copyToClipboard)(urlToCopy.current);
    setTextCopied(() => {
      if (copiedTextToolTipCleanupIdRef.current) {
        clearTimeout(copiedTextToolTipCleanupIdRef.current);
      }

      // set up timer to revert copied state to false after specified duration
      copiedTextToolTipCleanupIdRef.current = setTimeout(() => setTextCopied(false), 1000);

      // set copied state to true for now
      return true;
    });
    setIsLoading(false);
  }, [getEmbedLink]);
  const renderUrlParamExtensions = () => {
    if (!urlParamExtensions) {
      return null;
    }
    const setParamValue = paramName => (values = {}) => {
      urlParamsRef.current = {
        ...urlParamsRef.current,
        [paramName]: {
          ...values
        }
      };
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 7
      }
    }, urlParamExtensions.map(({
      paramName,
      component: UrlParamComponent
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      key: paramName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(UrlParamComponent, {
      setParamValue: setParamValue(paramName),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 13
      }
    }))));
  };
  const renderPublicUrlOptionsSwitch = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.embed.publicUrlOptionsSwitch.label",
        defaultMessage: "Allow public access",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 15
        }
      }),
      checked: usePublicUrl,
      onChange: e => setUsePublicUrl(e.target.checked),
      "data-test-subj": "embedPublicUrlOptionsSwitch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.embed.publicUrlOptionsSwitch.tooltip",
        defaultMessage: "Enabling public access generates a sharable URL that allows anonymous access without a login prompt.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 279,
          columnNumber: 15
        }
      }),
      type: "question",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 11
      }
    })));
  };
  const helpText = objectType === 'dashboard' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.embed.dashboard.helpText",
    defaultMessage: "Embed this dashboard into another webpage. Select which items to include in the embeddable view.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.embed.helpText",
    defaultMessage: "Embed this {objectType} into another webpage.",
    values: {
      objectType
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 7
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 9
    }
  }, helpText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 9
    }
  }), renderUrlParamExtensions(), isDirty && DraftModeCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 13
    }
  }), DraftModeCallout), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 9
    }
  }, showPublicUrlSwitch ? renderPublicUrlOptionsSwitch() : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isTextCopied ? _i18n.i18n.translate('share.embed.copied', {
      defaultMessage: 'Link copied'
    }) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "copyEmbedUrlButton",
    onClick: copyUrlHelper,
    "data-share-url": urlToCopy.current,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.embed.copyEmbedCodeButton",
    defaultMessage: "Copy embed code",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 15
    }
  }))))));
};
exports.EmbedContent = EmbedContent;