"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBadgeColorFromAlertStatus = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_TO_COLOR_MAP = {
  open: 'primary',
  acknowledged: 'warning',
  closed: 'default'
};
const getBadgeColorFromAlertStatus = status => STATUS_TO_COLOR_MAP[status || 'closed'];
exports.getBadgeColorFromAlertStatus = getBadgeColorFromAlertStatus;