"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultCsvArray = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Creates a schema of an array that works in the following way:
 *   - If input is a CSV string, it will be parsed to an array which will be validated.
 *   - If input is an array, each item is validated to match `itemSchema`.
 *   - If input is a single string, it is validated to match `itemSchema`.
 *   - If input is not specified, the result will be set to [] (empty array):
 *     - null, undefined, empty string, empty array
 *
 * In all cases when an input is valid, the resulting decoded value will be an array,
 * either an empty one or containing valid items.
 *
 * @param itemSchema Schema of the array's items.
 * @param name (Optional) Name of the resulting schema.
 */
const defaultCsvArray = (itemSchema, name) => {
  return new t.Type(name !== null && name !== void 0 ? name : `DefaultCsvArray<${itemSchema.name}>`, t.array(itemSchema).is, (input, context) => {
    if (input == null) {
      return t.success([]);
    } else if (typeof input === 'string') {
      if (input === '') {
        return t.success([]);
      } else {
        return t.array(itemSchema).validate(input.split(','), context);
      }
    } else {
      return t.array(itemSchema).validate(input, context);
    }
  }, t.identity);
};
exports.defaultCsvArray = defaultCsvArray;