"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setOnboardingSettings = void 0;
var _util = require("../navigation/util");
var _product = require("../../common/product");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setOnboardingSettings = services => {
  var _cloud$serverless;
  const {
    securitySolution,
    cloud
  } = services;
  const projectId = (_cloud$serverless = cloud.serverless) === null || _cloud$serverless === void 0 ? void 0 : _cloud$serverless.projectId;
  securitySolution.setOnboardingSettings({
    userUrl: (0, _util.getCloudUrl)('usersAndRoles', cloud),
    projectUrl: projectId ? `${(0, _util.getCloudUrl)('projects', cloud)}${`${_product.ProductLine.security}/${projectId}`}` : undefined,
    isAgentlessAvailable: true
  });
};
exports.setOnboardingSettings = setOnboardingSettings;