"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResponseActionsUsage = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getResponseActionsUsage = ruleAttributes => {
  var _ruleAttributes$param, _ruleAttributes$param2;
  if (ruleAttributes.params.responseActions == null || ruleAttributes.params.responseActions.length === 0) {
    return {
      hasResponseActions: false,
      hasResponseActionsEndpoint: false,
      hasResponseActionsOsquery: false
    };
  }
  switch (ruleAttributes.params.type) {
    case 'threshold':
    case 'query':
    case 'saved_query':
    case 'new_terms':
    case 'threat_match':
    case 'machine_learning':
    case 'esql':
    case 'eql':
      return {
        hasResponseActions: !!ruleAttributes.params.responseActions,
        hasResponseActionsEndpoint: !!((_ruleAttributes$param = ruleAttributes.params.responseActions) !== null && _ruleAttributes$param !== void 0 && _ruleAttributes$param.some(action => action.actionTypeId === '.endpoint')),
        hasResponseActionsOsquery: !!((_ruleAttributes$param2 = ruleAttributes.params.responseActions) !== null && _ruleAttributes$param2 !== void 0 && _ruleAttributes$param2.some(action => action.actionTypeId === '.osquery'))
      };
    default:
      return {
        hasResponseActions: false,
        hasResponseActionsEndpoint: false,
        hasResponseActionsOsquery: false
      };
  }
};
exports.getResponseActionsUsage = getResponseActionsUsage;