"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleMetricsSchema = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleMetricsSchema = exports.ruleMetricsSchema = {
  rule_name: {
    type: 'keyword',
    _meta: {
      description: 'The name of the detection rule'
    }
  },
  rule_id: {
    type: 'keyword',
    _meta: {
      description: 'The UUID id of the detection rule'
    }
  },
  rule_type: {
    type: 'keyword',
    _meta: {
      description: 'The type of detection rule. ie eql, query...'
    }
  },
  rule_version: {
    type: 'long',
    _meta: {
      description: 'The version of the rule'
    }
  },
  enabled: {
    type: 'boolean',
    _meta: {
      description: 'If the detection rule has been enabled by the user'
    }
  },
  is_customized: {
    type: 'boolean',
    _meta: {
      description: 'Whether this is a customized prebuilt rule'
    }
  },
  elastic_rule: {
    type: 'boolean',
    _meta: {
      description: 'If the detection rule has been authored by Elastic'
    }
  },
  created_on: {
    type: 'keyword',
    _meta: {
      description: 'When the detection rule was created on the cluster'
    }
  },
  updated_on: {
    type: 'keyword',
    _meta: {
      description: 'When the detection rule was updated on the cluster'
    }
  },
  alert_count_daily: {
    type: 'long',
    _meta: {
      description: 'The number of daily alerts generated by a rule'
    }
  },
  cases_count_total: {
    type: 'long',
    _meta: {
      description: 'The number of total cases generated by a rule'
    }
  },
  has_legacy_notification: {
    type: 'boolean',
    _meta: {
      description: 'True if this rule has a legacy notification'
    }
  },
  has_notification: {
    type: 'boolean',
    _meta: {
      description: 'True if this rule has a notification'
    }
  },
  has_legacy_investigation_field: {
    type: 'boolean',
    _meta: {
      description: 'True if this rule has a legacy investigation field'
    }
  },
  has_alert_suppression_missing_fields_strategy_do_not_suppress: {
    type: 'boolean',
    _meta: {
      description: 'True if this rule has alert suppression missing fields strategy do not suppress'
    }
  },
  has_alert_suppression_per_rule_execution: {
    type: 'boolean',
    _meta: {
      description: 'True if this rule has alert suppression per rule execution'
    }
  },
  has_alert_suppression_per_time_period: {
    type: 'boolean',
    _meta: {
      description: 'True if this rule has alert suppression per time period'
    }
  },
  alert_suppression_fields_count: {
    type: 'long',
    _meta: {
      description: 'The number of alert suppression fields for this rule'
    }
  },
  has_response_actions: {
    type: 'boolean',
    _meta: {
      description: 'True if this rule has response actions'
    }
  },
  has_response_actions_endpoint: {
    type: 'boolean',
    _meta: {
      description: 'True if this rule has endpoint response actions'
    }
  },
  has_response_actions_osquery: {
    type: 'boolean',
    _meta: {
      description: 'True if this rule has osquery response actions'
    }
  },
  has_exceptions: {
    type: 'boolean',
    _meta: {
      description: 'True if this rule has exceptions'
    }
  },
  has_does_not_match_condition: {
    type: 'boolean',
    _meta: {
      description: 'True if Threat match rule has does_not_match condition in threat mappings'
    }
  }
};