"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTimelinesStreamFromNdJson = void 0;
var _utils = require("@kbn/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _create_stream_from_ndjson = require("../../../../../utils/read_stream/create_stream_from_ndjson");
var _timeline = require("../../../../../../common/api/timeline");
var _zod_errors = require("../../../../../../common/timelines/zod_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPlainError = message => new Error(message);
const parseOrThrow = (0, _zod_errors.parseOrThrowErrorFactory)(createPlainError);
const validateTimelines = () => (0, _utils.createMapStream)(obj => obj instanceof Error ? new _securitysolutionEsUtils.BadRequestError(obj.message) : parseOrThrow(_timeline.ImportTimelines)(obj));
const createTimelinesStreamFromNdJson = ruleLimit => {
  return [(0, _utils.createSplitStream)('\n'), (0, _create_stream_from_ndjson.parseNdjsonStrings)(), (0, _create_stream_from_ndjson.filterExportedCounts)(), validateTimelines(), (0, _create_stream_from_ndjson.createLimitStream)(ruleLimit), (0, _utils.createConcatStream)([])];
};
exports.createTimelinesStreamFromNdJson = createTimelinesStreamFromNdJson;