"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelineRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../../common/constants");
var _utils = require("../../../../detection_engine/routes/utils");
var _common = require("../../../utils/common");
var _timeline = require("../../../../../../common/api/timeline");
var _timelines = require("../../../saved_object/timelines");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimelineRoute = router => {
  router.versioned.get({
    path: _constants.TIMELINE_URL,
    security: {
      authz: {
        requiredPrivileges: ['timeline_read']
      }
    },
    access: 'public'
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_timeline.GetTimelineRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      var _request$query;
      const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, request);
      const query = (_request$query = request.query) !== null && _request$query !== void 0 ? _request$query : {};
      const {
        template_timeline_id: templateTimelineId,
        id
      } = query;
      if (templateTimelineId != null && id == null) {
        const timeline = await (0, _timelines.getTimelineTemplateOrNull)(frameworkRequest, templateTimelineId);
        if (timeline) {
          return response.ok({
            body: timeline
          });
        }
      } else if (templateTimelineId == null && id != null) {
        const timelineOrNull = await (0, _timelines.getTimelineOrNull)(frameworkRequest, id);
        if (timelineOrNull) {
          return response.ok({
            body: timelineOrNull
          });
        }
      } else {
        throw new Error('please provide id or template_timeline_id');
      }
      return siemResponse.error({
        statusCode: 404,
        body: 'Could not find timeline'
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getTimelineRoute = getTimelineRoute;