"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatestReadinessTaskRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../common/api/siem_readiness/constants");
var _constants2 = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIEM_READINESS_INDEX = 'security_solution-siem_readiness';
const getLatestReadinessTaskRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.GET_LATEST_SIEM_READINESS_TASKS_API_PATH,
    access: 'public',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      var _searchResult$aggrega, _searchResult$aggrega2, _searchResult$aggrega3;
      const core = await context.core;
      const esClient = core.elasticsearch.client.asCurrentUser;
      const searchResult = await esClient.search({
        index: SIEM_READINESS_INDEX,
        size: 0,
        aggs: {
          latest_tasks: {
            terms: {
              field: 'task_id.keyword',
              size: 1000
            },
            aggs: {
              latest_doc: {
                top_hits: {
                  size: 1,
                  sort: [{
                    '@timestamp': {
                      order: 'desc'
                    }
                  }]
                }
              }
            }
          }
        }
      });

      // Extract the latest document for each task_id from aggregation results
      const latestTasks = ((_searchResult$aggrega = searchResult.aggregations) === null || _searchResult$aggrega === void 0 ? void 0 : (_searchResult$aggrega2 = _searchResult$aggrega.latest_tasks) === null || _searchResult$aggrega2 === void 0 ? void 0 : (_searchResult$aggrega3 = _searchResult$aggrega2.buckets) === null || _searchResult$aggrega3 === void 0 ? void 0 : _searchResult$aggrega3.map(bucket => bucket.latest_doc.hits.hits[0]._source)) || [];
      logger.info(`Retrieved ${latestTasks.length} latest SIEM readiness tasks from ${SIEM_READINESS_INDEX}`);
      return response.ok({
        body: latestTasks
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error retrieving SIEM readiness tasks: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.getLatestReadinessTaskRoute = getLatestReadinessTaskRoute;