"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SELECT_INDEX_PATTERN_PROMPT = void 0;
var _prompts = require("@langchain/core/prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SELECT_INDEX_PATTERN_PROMPT = exports.SELECT_INDEX_PATTERN_PROMPT = _prompts.ChatPromptTemplate.fromTemplate(`This is a ES|QL query for an Elastic dashboard panel, so you also provided with the \`title\` and \`description\` and \`query\` of the visualization panel, as context.
The index pattern in the context \`query\` is a dummy temporary index pattern, please ignore it, it will be replaced later.

<context>
  <title>{title}</title>
  <description>{description}</description>
  <query>{query}</query>
</context>
`);