"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggregateDashboardNode = void 0;
var _comments = require("../../../../../common/task/util/comments");
var _constants = require("../../../../../../../../common/siem_migrations/constants");
var _dashboard = _interopRequireDefault(require("./dashboard.json"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAggregateDashboardNode = () => {
  return async state => {
    var _state$translated_pan;
    const title = state.original_dashboard.title || 'Untitled Dashboard';
    const description = state.description || '';
    if (!((_state$translated_pan = state.translated_panels) !== null && _state$translated_pan !== void 0 && _state$translated_pan.length)) {
      return {
        elastic_dashboard: {
          title,
          description
        },
        translation_result: _constants.MigrationTranslationResult.UNTRANSLATABLE,
        comments: [(0, _comments.generateAssistantComment)('No panels found')]
      };
    }

    // Recover original order (the translated_panels is built asynchronously so the panels are in the order they complete the translation, not the original order)
    const panels = state.translated_panels.sort((a, b) => a.index - b.index);
    const allErrors = panels.every(panel => panel.error);
    if (allErrors) {
      // The dashboard migration status will be set to 'failed' and the error stored in the document.
      throw new Error(`All panels failed to translate. Aborting dashboard generation. First error: ${panels[0].error}` // Only show the first error to avoid overly long error messages
      );
    }

    // Create the dashboard object
    const dashboardData = structuredClone(_dashboard.default);
    dashboardData.attributes.title = title;
    dashboardData.attributes.description = description;
    dashboardData.attributes.panelsJSON = JSON.stringify(panels.map(({
      data
    }) => data));
    let translationResult;
    const allTranslated = panels.every(panel => panel.translation_result === _constants.MigrationTranslationResult.FULL);
    if (allTranslated) {
      translationResult = _constants.MigrationTranslationResult.FULL;
    } else {
      const allUntranslatable = panels.every(panel => panel.translation_result === _constants.MigrationTranslationResult.UNTRANSLATABLE);
      if (allUntranslatable) {
        translationResult = _constants.MigrationTranslationResult.UNTRANSLATABLE;
      } else {
        translationResult = _constants.MigrationTranslationResult.PARTIAL;
      }
    }

    // Aggregate all comments from the individual panel translations, with a header for each panel
    const comments = panels.flatMap(panel => {
      var _panel$comments;
      if ((_panel$comments = panel.comments) !== null && _panel$comments !== void 0 && _panel$comments.length) {
        return [(0, _comments.generateAssistantComment)(`# Panel "${panel.title}"`), ...panel.comments];
      }
      return [];
    });
    return {
      elastic_dashboard: {
        title,
        description,
        data: JSON.stringify(dashboardData)
      },
      translation_result: translationResult,
      comments
    };
  };
};
exports.getAggregateDashboardNode = getAggregateDashboardNode;