"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.casesProductFeatureParams = void 0;
var _common = require("@kbn/cases-plugin/common");
var _constants = require("@kbn/cases-plugin/common/constants");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const originalCasesUiCapabilities = (0, _common.createUICapabilities)();
const originalCasesApiTags = (0, _common.getApiTags)(_constants2.APP_ID);
const defaultUiCapabilities = {
  ...originalCasesUiCapabilities,
  all: originalCasesUiCapabilities.all.filter(capability => capability !== _constants.CASES_CONNECTORS_CAPABILITY),
  read: originalCasesUiCapabilities.read.filter(capability => capability !== _constants.CASES_CONNECTORS_CAPABILITY)
};
const defaultApiTags = {
  ...originalCasesApiTags,
  all: originalCasesApiTags.all.filter(capability => capability !== _constants.GET_CONNECTORS_CONFIGURE_API_TAG),
  read: originalCasesApiTags.read.filter(capability => capability !== _constants.GET_CONNECTORS_CONFIGURE_API_TAG)
};
const connectorsUiCapabilities = {
  all: [_constants.CASES_CONNECTORS_CAPABILITY],
  read: [_constants.CASES_CONNECTORS_CAPABILITY]
};
const connectorsApiTags = {
  all: [_constants.GET_CONNECTORS_CONFIGURE_API_TAG],
  read: [_constants.GET_CONNECTORS_CONFIGURE_API_TAG]
};
const casesProductFeatureParams = exports.casesProductFeatureParams = {
  apiTags: {
    default: defaultApiTags,
    connectors: connectorsApiTags
  },
  uiCapabilities: {
    default: defaultUiCapabilities,
    connectors: connectorsUiCapabilities
  },
  savedObjects: {
    files: _saved_objects.hiddenTypes
  }
};