"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deletePrivilegeMonitoringEngineRoute = void 0;
var _routes = require("@kbn/lists-plugin/server/routes");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _entity_analytics = require("../../../../../common/api/entity_analytics");
var _constants = require("../../../../../common/constants");
var _crud_service = require("../engine/crud_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deletePrivilegeMonitoringEngineRoute = (router, logger) => {
  router.versioned.delete({
    access: 'public',
    path: _constants.MONITORING_ENGINE_DELETE_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    },
    options: {
      availability: {
        since: '9.1.0',
        stability: 'stable'
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_entity_analytics.DeleteEntityEngineRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _routes.buildSiemResponse)(response);
    const secSol = await context.securitySolution;
    try {
      const dataClient = secSol.getPrivilegeMonitoringDataClient();
      const soClient = dataClient.getScopedSoClient(request);
      const service = (0, _crud_service.createEngineCrudService)(dataClient, soClient);
      const body = await service.delete(request.query.data);
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error deleting privilege monitoring engine: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.deletePrivilegeMonitoringEngineRoute = deletePrivilegeMonitoringEngineRoute;