"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findStaleUsersFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findStaleUsersFactory = dataClient => async (sourceId, userNames, labelsSource) => {
  const esClient = dataClient.deps.clusterClient.asCurrentUser;
  const response = await esClient.search({
    index: dataClient.index,
    size: 10,
    // check this
    _source: ['user.name', 'labels.source_ids'],
    query: {
      bool: {
        must: [{
          term: {
            'user.is_privileged': true
          }
        }, {
          term: {
            'labels.sources': labelsSource
          }
        }, {
          term: {
            'labels.source_ids.keyword': sourceId
          }
        }],
        must_not: {
          terms: {
            'user.name': userNames
          }
        }
      }
    }
  });
  return response.hits.hits.map(hit => {
    var _hit$_source$user$nam, _hit$_source, _hit$_source$user;
    return {
      username: (_hit$_source$user$nam = (_hit$_source = hit._source) === null || _hit$_source === void 0 ? void 0 : (_hit$_source$user = _hit$_source.user) === null || _hit$_source$user === void 0 ? void 0 : _hit$_source$user.name) !== null && _hit$_source$user$nam !== void 0 ? _hit$_source$user$nam : 'unknown',
      existingUserId: hit._id,
      sourceId,
      isPrivileged: false
    };
  });
};
exports.findStaleUsersFactory = findStaleUsersFactory;