"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUpdateDetectionService = void 0;
var _privileged_status_match = require("./privileged_status_match");
var _privileged_status_update = require("./privileged_status_update");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createUpdateDetectionService = (dataClient, soClient) => {
  const patternMatcherService = (0, _privileged_status_match.createPatternMatcherService)(dataClient, soClient);
  const statusUpdateService = (0, _privileged_status_update.createPrivilegeStatusUpdateService)(dataClient);
  const updateDetection = async source => {
    const users = await patternMatcherService.findPrivilegedUsersFromMatchers(source);
    await statusUpdateService.updatePrivilegedStatus(users, source);
    dataClient.log('info', `Completed update detection for source ${source.id}. Processed ${users.length} users.`);
  };
  return {
    updateDetection
  };
};
exports.createUpdateDetectionService = createUpdateDetectionService;