"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBulkUtilsService = void 0;
var _soft_delete = require("./soft_delete");
var _upsert = require("./upsert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createBulkUtilsService = dataClient => {
  const bulkUpsertOperations = (0, _upsert.bulkUpsertOperationsFactory)(dataClient);
  const bulkSoftDeleteOperations = (0, _soft_delete.bulkSoftDeleteOperationsFactory)(dataClient);
  return {
    bulkUpsertOperations,
    bulkSoftDeleteOperations
  };
};
exports.createBulkUtilsService = createBulkUtilsService;