"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateInitializationRequestBody = exports.buildInitRequestBodyValidation = void 0;
var _common = require("@kbn/alerting-plugin/common");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildInitRequestBodyValidation = schema => (inputValue, validationResultFactory) => {
  const zodValidationResult = (0, _zodHelpers.buildRouteValidationWithZod)(schema)(inputValue, validationResultFactory);
  if (zodValidationResult.error) return zodValidationResult;
  const additionalValidationResult = validateInitializationRequestBody(zodValidationResult.value);
  if (additionalValidationResult) return validationResultFactory.badRequest(additionalValidationResult);
  return zodValidationResult;
};

/**
 * Validations performed:
 * - Ensures that the enrich policy execution interval is less than or equal to half the duration of the lookback period,
 * as the execution policy must run successfully at least once within the lookback period in order to ensure no loss of
 * data
 */
exports.buildInitRequestBodyValidation = buildInitRequestBodyValidation;
const validateInitializationRequestBody = requestBody => {
  const {
    lookbackPeriod,
    enrichPolicyExecutionInterval
  } = requestBody;
  if (!lookbackPeriod || !enrichPolicyExecutionInterval) return;
  const lookbackPeriodMillis = (0, _common.parseDuration)(lookbackPeriod);
  const enrichPolicyExecutionIntervalMillis = (0, _common.parseDuration)(enrichPolicyExecutionInterval);
  if (enrichPolicyExecutionIntervalMillis > lookbackPeriodMillis / 2) {
    return new _securitysolutionEsUtils.BadRequestError('The enrich policy execution interval must be less than or equal to half the duration of the lookback period.');
  }
};
exports.validateInitializationRequestBody = validateInitializationRequestBody;