"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityILMPolicyStatuses = getEntityILMPolicyStatuses;
var _constants_entities = require("@kbn/entityManager-plugin/common/constants_entities");
var _entity_analytics = require("../../../../../common/api/entity_analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getEntityILMPolicyStatuses({
  esClient,
  isServerless
}) {
  if (isServerless) {
    return Promise.resolve([]);
  }
  const namesToCheck = [_constants_entities.ENTITY_HISTORY_ILM_POLICY];
  const result = await Promise.all(namesToCheck.map(async name => {
    let exists = false;
    try {
      await esClient.ilm.getLifecycle({
        name
      });
      exists = true;
    } catch (e) {
      exists = false;
    }
    return {
      id: name,
      installed: exists,
      resource: _entity_analytics.EngineComponentResourceEnum.ilm_policy
    };
  }));
  return result;
}