"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrebuiltRuleAsset = exports.PrebuiltAssetBaseProps = void 0;
var z = _interopRequireWildcard(require("@kbn/zod"));
var _rule_schema = require("../../../../../../common/api/detection_engine/model/rule_schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function zodMaskFor() {
  return function (props) {
    const propObjects = props.map(p => ({
      [p]: true
    }));
    return Object.assign({}, ...propObjects);
  };
}
/**
 * The PrebuiltRuleAsset schema is created based on the rule schema defined in our OpenAPI specs.
 * However, we don't need all the rule schema fields to be present in the PrebuiltRuleAsset.
 * We omit some of them because they are not present in https://github.com/elastic/detection-rules.
 * Context: https://github.com/elastic/kibana/issues/180393
 */
const BASE_PROPS_REMOVED_FROM_PREBUILT_RULE_ASSET = zodMaskFor()(['actions', 'response_actions', 'throttle', 'meta', 'output_index', 'namespace', 'alias_purpose', 'alias_target_id', 'outcome']);
const PrebuiltAssetBaseProps = exports.PrebuiltAssetBaseProps = _rule_schema.BaseCreateProps.omit(BASE_PROPS_REMOVED_FROM_PREBUILT_RULE_ASSET);

/**
 * Asset containing source content of a prebuilt Security detection rule.
 * Is defined for each prebuilt rule in https://github.com/elastic/detection-rules.
 * Is shipped via the `security_detection_engine` Fleet package.
 * Is installed as saved objects of type "security-rule" when the package is installed.
 *
 * Additionally, "security-rule" assets can be shipped via other Fleet packages, such as:
 *   - LotL Attack Detection https://github.com/elastic/integrations/pull/2115
 *   - Data Exfiltration Detection
 *
 * Big differences between this schema and RuleCreateProps:
 *  - rule_id is a required field
 *  - version is a required field
 *  - some fields are omitted because they are not present in https://github.com/elastic/detection-rules
 */

const PrebuiltRuleAsset = exports.PrebuiltRuleAsset = PrebuiltAssetBaseProps.and(_rule_schema.TypeSpecificCreatePropsInternal).and(z.object({
  rule_id: _rule_schema.RuleSignatureId,
  version: _rule_schema.RuleVersion
}));