"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installEndpointPackage = installEndpointPackage;
var _constants = require("../../../../../../common/detection_engine/constants");
var _find_latest_package_version = require("./find_latest_package_version");
var _ensure_installed_package = require("./ensure_installed_package");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function installEndpointPackage(context, logger) {
  const pkgVersion = await (0, _find_latest_package_version.findLatestPackageVersion)(context, _constants.ENDPOINT_PACKAGE_NAME, logger);
  return (0, _ensure_installed_package.ensureInstalledPackage)(context, _constants.ENDPOINT_PACKAGE_NAME, pkgVersion, logger);
}