"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnsupportedResponseActionsAgentTypeError = exports.ResponseActionsNotSupportedError = exports.ResponseActionsConnectorNotConfiguredError = exports.ResponseActionsClientError = exports.ResponseActionAgentResponseEsDocNotFound = void 0;
var _stringify = require("../../../utils/stringify");
var _custom_http_request_error = require("../../../../utils/custom_http_request_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */

/**
 * Errors associated with Response Actions clients
 */
class ResponseActionsClientError extends _custom_http_request_error.CustomHttpRequestError {
  toJSON() {
    return {
      message: this.message,
      statusCode: this.statusCode,
      meta: this.meta,
      stack: this.stack
    };
  }
  toString() {
    return (0, _stringify.stringify)(this.toJSON());
  }
}
exports.ResponseActionsClientError = ResponseActionsClientError;
class ResponseActionsNotSupportedError extends ResponseActionsClientError {
  constructor(responseAction, statusCode = 405, meta) {
    super(`Action ${responseAction ? `[${responseAction}] ` : ''}not supported`, statusCode, meta);
  }
}
exports.ResponseActionsNotSupportedError = ResponseActionsNotSupportedError;
class UnsupportedResponseActionsAgentTypeError extends ResponseActionsClientError {
  constructor(message, statusCode = 501, meta) {
    super(message, statusCode, meta);
  }
}
exports.UnsupportedResponseActionsAgentTypeError = UnsupportedResponseActionsAgentTypeError;
class ResponseActionsConnectorNotConfiguredError extends ResponseActionsClientError {
  constructor(connectorTypeId, statusCode = 400, meta) {
    super(`No stack connector instance configured for [${connectorTypeId}]`, statusCode, meta);
    this.statusCode = statusCode;
    this.meta = meta;
  }
}
exports.ResponseActionsConnectorNotConfiguredError = ResponseActionsConnectorNotConfiguredError;
class ResponseActionAgentResponseEsDocNotFound extends ResponseActionsClientError {}
exports.ResponseActionAgentResponseEsDocNotFound = ResponseActionAgentResponseEsDocNotFound;