"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerProtectionUpdatesNoteRoutes = registerProtectionUpdatesNoteRoutes;
var _handlers = require("./handlers");
var _protection_updates_note = require("../../../../common/api/endpoint/protection_updates_note");
var _with_endpoint_authz = require("../with_endpoint_authz");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerProtectionUpdatesNoteRoutes(router, endpointAppContext) {
  const logger = endpointAppContext.logFactory.get('protectionUpdatesNote');
  router.versioned.post({
    access: 'public',
    path: _constants.PROTECTION_UPDATES_NOTE_ROUTE,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      authRequired: true
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: _protection_updates_note.CreateUpdateProtectionUpdatesNoteSchema
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canWritePolicyManagement']
  }, logger, (0, _handlers.postProtectionUpdatesNoteHandler)(endpointAppContext)));
  router.versioned.get({
    access: 'public',
    path: _constants.PROTECTION_UPDATES_NOTE_ROUTE,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      authRequired: true
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: _protection_updates_note.GetProtectionUpdatesNoteSchema
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    all: ['canReadPolicyManagement']
  }, logger, (0, _handlers.getProtectionUpdatesNoteHandler)(endpointAppContext)));
}