"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unifiedManifestType = exports.unifiedManifestSavedObjectType = exports.unifiedManifestSavedObjectMappings = exports.manifestType = exports.manifestSavedObjectType = exports.manifestSavedObjectMappings = exports.exceptionsArtifactSavedObjectType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _common = require("./common");
var _migrations = require("./migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exceptionsArtifactSavedObjectType = exports.exceptionsArtifactSavedObjectType = _common.ArtifactConstants.SAVED_OBJECT_TYPE;
const manifestSavedObjectType = exports.manifestSavedObjectType = _common.ManifestConstants.SAVED_OBJECT_TYPE;
const manifestSavedObjectMappings = exports.manifestSavedObjectMappings = {
  dynamic: false,
  properties: {
    schemaVersion: {
      type: 'keyword'
    },
    artifacts: {
      type: 'nested'
    }
  }
};
const manifestType = exports.manifestType = {
  name: manifestSavedObjectType,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'agnostic',
  mappings: manifestSavedObjectMappings,
  migrations: _migrations.migrations
};
const unifiedManifestSavedObjectType = exports.unifiedManifestSavedObjectType = _common.ManifestConstants.UNIFIED_SAVED_OBJECT_TYPE;
const unifiedManifestSavedObjectMappings = exports.unifiedManifestSavedObjectMappings = {
  dynamic: false,
  properties: {
    artifactIds: {
      type: 'keyword'
    },
    policyId: {
      type: 'keyword'
    },
    semanticVersion: {
      type: 'keyword'
    }
  }
};
const unifiedManifestType = exports.unifiedManifestType = {
  name: unifiedManifestSavedObjectType,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple',
  mappings: unifiedManifestSavedObjectMappings
};