"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requireFirstInspectIndexMappingCallWithEmptyKey = exports.messageContainsToolCalls = exports.getPromptSuffixForOssModel = void 0;
var _messages = require("@langchain/core/messages");
var _inspect_index_mapping_tool = require("../tools/inspect_index_mapping_tool/inspect_index_mapping_tool");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPromptSuffixForOssModel = toolName => `
  When using ${toolName} tool ALWAYS pass the user's questions directly as input into the tool.

  Always return value from ${toolName} tool as is.

  The ES|QL query should ALWAYS be wrapped in triple backticks ("\`\`\`esql"). Add a new line character right before the triple backticks.

  It is important that ES|QL query is preceeded by a new line.`;
exports.getPromptSuffixForOssModel = getPromptSuffixForOssModel;
const messageContainsToolCalls = message => {
  var _message$tool_calls;
  return 'tool_calls' in message && Array.isArray(message.tool_calls) && ((_message$tool_calls = message.tool_calls) === null || _message$tool_calls === void 0 ? void 0 : _message$tool_calls.length) > 0;
};
exports.messageContainsToolCalls = messageContainsToolCalls;
const requireFirstInspectIndexMappingCallWithEmptyKey = (newMessage, oldMessages) => {
  const hasCalledInspectIndexMappingTool = oldMessages.find(message => {
    var _message$tool_calls2;
    return messageContainsToolCalls(message) && ((_message$tool_calls2 = message.tool_calls) === null || _message$tool_calls2 === void 0 ? void 0 : _message$tool_calls2.some(toolCall => {
      return toolCall.name === _inspect_index_mapping_tool.toolDetails.name;
    }));
  });
  if (hasCalledInspectIndexMappingTool) {
    return newMessage;
  }
  const newMessageToolCalls = newMessage.tool_calls || [];
  const containsFirstInspectIndexMappingCall = newMessageToolCalls.some(toolCall => {
    return toolCall.name === _inspect_index_mapping_tool.toolDetails.name;
  });
  if (!containsFirstInspectIndexMappingCall) {
    return newMessage;
  }
  const modifiedToolCalls = [];
  let hasModifiedToolCall = false;
  for (const toolCall of newMessageToolCalls) {
    if (toolCall.name === _inspect_index_mapping_tool.toolDetails.name && !hasModifiedToolCall) {
      modifiedToolCalls.push({
        ...toolCall,
        args: {
          ...toolCall.args,
          property: ''
        }
      });
      hasModifiedToolCall = true;
    } else {
      modifiedToolCalls.push(toolCall);
    }
  }
  return new _messages.AIMessage({
    content: newMessage.content,
    tool_calls: modifiedToolCalls
  });
};
exports.requireFirstInspectIndexMappingCallWithEmptyKey = requireFirstInspectIndexMappingCallWithEmptyKey;