"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverState = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _actions = require("../../../../../common/store/discover/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDiscoverState = () => {
  const discoverAppState = (0, _reactRedux.useSelector)(state => {
    const result = state.discover.app;
    return result;
  });
  const discoverInternalState = (0, _reactRedux.useSelector)(state => {
    const result = state.discover.internal;
    return result;
  });
  const discoverSavedSearchState = (0, _reactRedux.useSelector)(state => {
    const result = state.discover.savedSearch;
    return result;
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const setDiscoverAppState = (0, _react.useCallback)(newState => {
    dispatch((0, _actions.updateDiscoverAppState)({
      newState
    }));
  }, [dispatch]);
  const setDiscoverInternalState = (0, _react.useCallback)(newState => {
    dispatch((0, _actions.updateDiscoverInternalState)({
      newState
    }));
  }, [dispatch]);
  const setDiscoverSavedSearchState = (0, _react.useCallback)(newState => {
    dispatch((0, _actions.updateDiscoverSavedSearchState)({
      newState
    }));
  }, [dispatch]);
  return {
    discoverAppState,
    setDiscoverAppState,
    discoverInternalState,
    setDiscoverInternalState,
    discoverSavedSearchState,
    setDiscoverSavedSearchState
  };
};
exports.useDiscoverState = useDiscoverState;