"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EqlTabContentComponent = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactReversePortal = require("react-reverse-portal");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _use_fetch_notes = require("../../../../../notes/hooks/use_fetch_notes");
var _constants = require("../../../../../common/store/inputs/constants");
var _kibana = require("../../../../../common/lib/kibana");
var _panel_keys = require("../../../../../flyout/document_details/shared/constants/panel_keys");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _store = require("../../../../store");
var _containers = require("../../../../containers");
var _timeline = require("../../../../../../common/types/timeline");
var _store2 = require("../../../../../common/store");
var _model = require("../../../../../sourcerer/store/model");
var _defaults = require("../../../../store/defaults");
var _containers2 = require("../../../../../sourcerer/containers");
var _use_timeline_events_count = require("../../../../../common/hooks/use_timeline_events_count");
var _use_full_screen = require("../../../../../common/containers/use_full_screen");
var _layout = require("../shared/layout");
var _utils = require("../shared/utils");
var _unified_timeline_body = require("../../body/unified_timeline_body");
var _header = require("./header");
var _use_timeline_columns = require("../shared/use_timeline_columns");
var _use_timeline_control_columns = require("../shared/use_timeline_control_columns");
var _left = require("../../../../../flyout/document_details/left");
var _use_notes_in_flyout = require("../../properties/use_notes_in_flyout");
var _notes_flyout = require("../../properties/notes_flyout");
var _telemetry = require("../../../../../common/lib/telemetry");
var _refetch_timeline = require("../../refetch_timeline");
var _use_data_view = require("../../../../../data_view_manager/hooks/use_data_view");
var _use_selected_patterns = require("../../../../../data_view_manager/hooks/use_selected_patterns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/tabs/eql/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EqlTabContentComponent = ({
  activeTab,
  columns,
  end,
  eqlOptions,
  timelineId,
  itemsPerPage,
  itemsPerPageOptions,
  rowRenderers,
  start,
  timerangeKind,
  pinnedEventIds,
  eventIdToNoteIds
}) => {
  var _experimentalDataView;
  /*
   * Needs to be maintained for each table in each tab independently
   * and consequently it cannot be the part of common redux state
   * of the timeline.
   *
   */
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    query: eqlQuery = '',
    ...restEqlOption
  } = eqlOptions;
  const {
    portalNode: eqlEventsCountPortalNode
  } = (0, _use_timeline_events_count.useEqlEventsCountPortal)();
  const {
    setTimelineFullScreen,
    timelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataViewId: oldDataViewId,
    loading: oldSourcererLoading,
    selectedPatterns: oldSelectedPatterns,
    sourcererDataView: oldSourcererDataViewSpec
  } = (0, _containers2.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.timeline);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_model.SourcererScopeName.timeline);
  const experimentalDataViewId = (_experimentalDataView = experimentalDataView.id) !== null && _experimentalDataView !== void 0 ? _experimentalDataView : null;
  const dataViewId = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalDataViewId : oldDataViewId, [experimentalDataViewId, newDataViewPickerEnabled, oldDataViewId]);
  const dataViewLoading = (0, _react.useMemo)(() => newDataViewPickerEnabled ? status !== 'ready' : oldSourcererLoading, [newDataViewPickerEnabled, oldSourcererLoading, status]);
  const runtimeMappings = (0, _react.useMemo)(() => {
    return newDataViewPickerEnabled ? experimentalDataView.getRuntimeMappings() : oldSourcererDataViewSpec.runtimeFieldMap;
  }, [newDataViewPickerEnabled, experimentalDataView, oldSourcererDataViewSpec.runtimeFieldMap]);
  const selectedPatterns = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns, [experimentalSelectedPatterns, newDataViewPickerEnabled, oldSelectedPatterns]);
  const {
    augmentedColumnHeaders,
    timelineQueryFieldsFromColumns
  } = (0, _use_timeline_columns.useTimelineColumns)(columns);
  const getManageTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const currentTimeline = (0, _use_selector.useDeepEqualSelector)(state => getManageTimeline(state, timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active));
  const {
    sampleSize
  } = currentTimeline;
  const isBlankTimeline = (0, _fp.isEmpty)(eqlQuery);
  const canQueryTimeline = (0, _react.useCallback)(() => dataViewLoading != null && !dataViewLoading && !(0, _fp.isEmpty)(start) && !(0, _fp.isEmpty)(end) && !isBlankTimeline, [end, isBlankTimeline, dataViewLoading, start]);
  const [dataLoadingState, {
    events,
    inspect,
    totalCount,
    loadNextBatch,
    refreshedAt,
    refetch
  }] = (0, _containers.useTimelineEvents)({
    dataViewId,
    endDate: end,
    eqlOptions: restEqlOption,
    fields: timelineQueryFieldsFromColumns,
    filterQuery: eqlQuery !== null && eqlQuery !== void 0 ? eqlQuery : '',
    id: timelineId,
    indexNames: selectedPatterns,
    language: 'eql',
    limit: sampleSize,
    runtimeMappings,
    skip: !canQueryTimeline(),
    startDate: start,
    timerangeKind
  });
  const {
    onLoad: loadNotesOnEventsLoad
  } = (0, _use_fetch_notes.useFetchNotes)();
  (0, _react.useEffect)(() => {
    // This useEffect loads the notes only for the events on the current
    // page.
    const eventsOnCurrentPage = events.slice(itemsPerPage * pageIndex, itemsPerPage * (pageIndex + 1));
    if (eventsOnCurrentPage.length > 0) {
      loadNotesOnEventsLoad(eventsOnCurrentPage);
    }
  }, [events, pageIndex, itemsPerPage, loadNotesOnEventsLoad]);

  /**
   *
   * Triggers on Datagrid page change
   *
   */
  const onUpdatePageIndex = (0, _react.useCallback)(newPageIndex => setPageIndex(newPageIndex), []);
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const securitySolutionNotesDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('securitySolutionNotesDisabled');
  const {
    associateNote,
    notes,
    isNotesFlyoutVisible,
    closeNotesFlyout,
    showNotesFlyout,
    eventId: noteEventId,
    setNotesEventId
  } = (0, _use_notes_in_flyout.useNotesInFlyout)({
    eventIdToNoteIds,
    refetch,
    timelineId,
    activeTab: _timeline.TimelineTabs.eql
  });
  const onToggleShowNotes = (0, _react.useCallback)(eventId => {
    const indexName = selectedPatterns.join(',');
    if (eventId && !securitySolutionNotesDisabled) {
      openFlyout({
        right: {
          id: _panel_keys.DocumentDetailsRightPanelKey,
          params: {
            id: eventId,
            indexName,
            scopeId: timelineId
          }
        },
        left: {
          id: _panel_keys.DocumentDetailsLeftPanelKey,
          path: {
            tab: _left.LeftPanelNotesTab
          },
          params: {
            id: eventId,
            indexName,
            scopeId: timelineId
          }
        }
      });
      telemetry.reportEvent(_telemetry.NotesEventTypes.OpenNoteInExpandableFlyoutClicked, {
        location: timelineId
      });
      telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
        location: timelineId,
        panel: 'left'
      });
    } else {
      if (eventId) {
        setNotesEventId(eventId);
        showNotesFlyout();
      }
    }
  }, [openFlyout, securitySolutionNotesDisabled, selectedPatterns, telemetry, timelineId, setNotesEventId, showNotesFlyout]);
  const leadingControlColumns = (0, _use_timeline_control_columns.useTimelineControlColumn)({
    timelineId,
    refetch,
    events,
    pinnedEventIds,
    eventIdToNoteIds,
    onToggleShowNotes
  });
  const isQueryLoading = (0, _react.useMemo)(() => dataLoadingState === _unifiedDataTable.DataLoadingState.loading || dataLoadingState === _unifiedDataTable.DataLoadingState.loadingMore, [dataLoadingState]);
  const unifiedHeader = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header.EqlTabHeader, {
    activeTab: activeTab,
    setTimelineFullScreen: setTimelineFullScreen,
    timelineFullScreen: timelineFullScreen,
    timelineId: timelineId,
    newDataViewPickerEnabled: newDataViewPickerEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 9
    }
  })), [activeTab, newDataViewPickerEnabled, setTimelineFullScreen, timelineFullScreen, timelineId]);
  const NotesFlyoutMemo = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_notes_flyout.NotesFlyout, {
      associateNote: associateNote,
      eventId: noteEventId,
      show: isNotesFlyoutVisible,
      notes: notes,
      onClose: closeNotesFlyout,
      onCancel: closeNotesFlyout,
      timelineId: timelineId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 7
      }
    });
  }, [associateNote, closeNotesFlyout, isNotesFlyoutVisible, noteEventId, notes, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_refetch_timeline.TimelineRefetch, {
    id: `${timelineId}-${_timeline.TimelineTabs.eql}`,
    inputId: _constants.InputsModelId.timeline,
    inspect: inspect,
    loading: isQueryLoading,
    refetch: refetch,
    skip: !canQueryTimeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: eqlEventsCountPortalNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 7
    }
  }, totalCount >= 0 ? /*#__PURE__*/_react.default.createElement(_layout.EventsCountBadge, {
    "data-test-subj": "eql-events-count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 11
    }
  }, totalCount) : null), NotesFlyoutMemo, /*#__PURE__*/_react.default.createElement(_layout.FullWidthFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_unified_timeline_body.UnifiedTimelineBody, {
    header: unifiedHeader,
    columns: augmentedColumnHeaders,
    isSortEnabled: false,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    itemsPerPage: itemsPerPage,
    itemsPerPageOptions: itemsPerPageOptions,
    sort: _utils.TIMELINE_NO_SORTING,
    events: events,
    refetch: refetch,
    dataLoadingState: dataLoadingState,
    totalCount: isBlankTimeline ? 0 : totalCount,
    onFetchMoreRecords: loadNextBatch,
    activeTab: activeTab,
    updatedAt: refreshedAt,
    isTextBasedQuery: false,
    leadingControlColumns: leadingControlColumns,
    onUpdatePageIndex: onUpdatePageIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 9
    }
  })));
};
exports.EqlTabContentComponent = EqlTabContentComponent;
const makeMapStateToProps = () => {
  const getTimeline = _store.timelineSelectors.getTimelineByIdSelector();
  const getInputsTimeline = _store2.inputsSelectors.getTimelineSelector();
  const mapStateToProps = (state, {
    timelineId
  }) => {
    var _getTimeline;
    const timeline = (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
    const input = getInputsTimeline(state);
    const {
      activeTab,
      columns,
      eqlOptions,
      itemsPerPage,
      itemsPerPageOptions,
      pinnedEventIds,
      eventIdToNoteIds
    } = timeline;
    return {
      activeTab,
      columns,
      eqlOptions,
      end: input.timerange.to,
      timelineId,
      isLive: input.policy.kind === 'interval',
      itemsPerPage,
      itemsPerPageOptions,
      pinnedEventIds,
      eventIdToNoteIds,
      start: input.timerange.from,
      timerangeKind: input.timerange.kind
    };
  };
  return mapStateToProps;
};
const connector = (0, _reactRedux.connect)(makeMapStateToProps);
const EqlTabContent = exports.default = connector(/*#__PURE__*/_react.default.memo(EqlTabContentComponent, (prevProps, nextProps) => prevProps.activeTab === nextProps.activeTab && (0, _utils.isTimerangeSame)(prevProps, nextProps) && (0, _fastDeepEqual.default)(prevProps.eqlOptions, nextProps.eqlOptions) && prevProps.isLive === nextProps.isLive && prevProps.itemsPerPage === nextProps.itemsPerPage && prevProps.timelineId === nextProps.timelineId && (0, _fastDeepEqual.default)(prevProps.columns, nextProps.columns) && (0, _fastDeepEqual.default)(prevProps.pinnedEventIds, nextProps.pinnedEventIds) && (0, _fastDeepEqual.default)(prevProps.eventIdToNoteIds, nextProps.eventIdToNoteIds) && (0, _fastDeepEqual.default)(prevProps.itemsPerPageOptions, nextProps.itemsPerPageOptions)));

// eslint-disable-next-line import/no-default-export