"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.options = exports.modes = exports.getPlaceholderText = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _and_or_badge = require("../../../../common/components/and_or_badge");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/search_or_filter/helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AndOrContainer = _styledComponents.default.div`
  position: relative;
  top: -1px;
`;
AndOrContainer.displayName = 'AndOrContainer';
const modes = exports.modes = {
  filter: {
    mode: 'filter',
    description: i18n.FILTER_DESCRIPTION,
    kqlBarTooltip: i18n.FILTER_KQL_TOOLTIP,
    placeholder: i18n.FILTER_KQL_PLACEHOLDER,
    selectText: i18n.FILTER_KQL_SELECTED_TEXT
  },
  search: {
    mode: 'search',
    description: i18n.SEARCH_DESCRIPTION,
    kqlBarTooltip: i18n.SEARCH_KQL_TOOLTIP,
    placeholder: i18n.SEARCH_KQL_PLACEHOLDER,
    selectText: i18n.SEARCH_KQL_SELECTED_TEXT
  }
};
const options = exports.options = [{
  value: modes.filter.mode,
  inputDisplay: /*#__PURE__*/_react.default.createElement(AndOrContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    type: "and",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }), modes.filter.selectText),
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    type: "and",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, modes.filter.selectText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, modes.filter.description))),
  'data-test-subj': 'kqlModePopoverFilter'
}, {
  value: modes.search.mode,
  inputDisplay: /*#__PURE__*/_react.default.createElement(AndOrContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    type: "or",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }), modes.search.selectText),
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    type: "or",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, modes.search.selectText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, modes.search.description))),
  'data-test-subj': 'kqlModePopoverSearch'
}];
const getPlaceholderText = kqlMode => kqlMode === 'filter' ? i18n.FILTER_KQL_PLACEHOLDER : i18n.SEARCH_KQL_PLACEHOLDER;
exports.getPlaceholderText = getPlaceholderText;