"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRowRenderer = void 0;
var _alert_renderer = require("./alert_renderer");
var _combine_renderers = require("./combine_renderers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This function may be used by both Timeline and the `Event Rendered view` in
 * the Alerts table to return the first instance of a `RowRenderer` that
 * matches the data
 */
const getRowRenderer = ({
  data,
  rowRenderers
}) => {
  var _rowRenderers$find;
  const renderer = (_rowRenderers$find = rowRenderers.find(rowRenderer => rowRenderer.isInstance(data))) !== null && _rowRenderers$find !== void 0 ? _rowRenderers$find : null;
  if (_alert_renderer.alertRenderer.isInstance(data)) {
    if (renderer != null) {
      // The combined renderer will display details about the alert, combined
      // with the content from the event renderer that was found:
      return (0, _combine_renderers.combineRenderers)({
        a: _alert_renderer.alertRenderer,
        b: renderer,
        id: renderer.id
      });
    } else {
      return _alert_renderer.alertRenderer;
    }
  }
  return renderer;
};
exports.getRowRenderer = getRowRenderer;