"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserNameField = exports.getUserDomainField = exports.getTargetUserAndTargetDomain = exports.getHumanReadableLogonType = exports.getHostNameSeparator = exports.getEventDetails = void 0;
var _helpers = require("../helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHumanReadableLogonType = endgameLogonType => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(endgameLogonType)) {
    return '';
  }
  switch (endgameLogonType) {
    case 2:
      return i18n.LOGON_TYPE_INTERACTIVE;
    case 3:
      return i18n.LOGON_TYPE_NETWORK;
    case 4:
      return i18n.LOGON_TYPE_BATCH;
    case 5:
      return i18n.LOGON_TYPE_SERVICE;
    case 7:
      return i18n.LOGON_TYPE_UNLOCK;
    case 8:
      return i18n.LOGON_TYPE_NETWORK_CLEARTEXT;
    case 9:
      return i18n.LOGON_TYPE_NEW_CREDENTIALS;
    case 10:
      return i18n.LOGON_TYPE_REMOTE_INTERACTIVE;
    case 11:
      return i18n.LOGON_TYPE_CACHED_INTERACTIVE;
    default:
      return `${endgameLogonType}`;
  }
};
exports.getHumanReadableLogonType = getHumanReadableLogonType;
const getHostNameSeparator = eventAction => eventAction === 'explicit_user_logon' ? i18n.TO : '@';
exports.getHostNameSeparator = getHostNameSeparator;
const getTargetUserAndTargetDomain = eventAction => eventAction === 'explicit_user_logon' || eventAction === 'user_logoff';
exports.getTargetUserAndTargetDomain = getTargetUserAndTargetDomain;
const getUserDomainField = eventAction => getTargetUserAndTargetDomain(eventAction) ? 'endgame.target_domain_name' : 'user.domain';
exports.getUserDomainField = getUserDomainField;
const getUserNameField = eventAction => getTargetUserAndTargetDomain(eventAction) ? 'endgame.target_user_name' : 'user.name';
exports.getUserNameField = getUserNameField;
const getEventDetails = ({
  eventAction,
  eventOutcome
}) => {
  switch (eventAction) {
    case 'explicit_user_logon':
      return '';
    // no details
    case 'log_off': // fall through
    case 'user_logoff':
      return (eventOutcome === null || eventOutcome === void 0 ? void 0 : eventOutcome.toLowerCase()) === 'failure' ? i18n.FAILED_TO_LOG_OFF : i18n.LOGGED_OFF;
    default:
      return (eventOutcome === null || eventOutcome === void 0 ? void 0 : eventOutcome.toLowerCase()) === 'failure' ? i18n.FAILED_TO_LOG_IN : i18n.SUCCESSFULLY_LOGGED_IN;
  }
};
exports.getEventDetails = getEventDetails;