"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_TIMELINE_BUTTON = exports.OPEN_TIMELINE = exports.NEW_TIMELINE = exports.NEW_TEMPLATE_TIMELINE = exports.ADD_TIMELINE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TIMELINE = exports.ADD_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.bottomBar.addButtonLabel', {
  defaultMessage: 'Add new timeline or template'
});
const NEW_TIMELINE = exports.NEW_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.bottomBar.newTimelineButtonLabel', {
  defaultMessage: 'Create new Timeline'
});
const NEW_TEMPLATE_TIMELINE = exports.NEW_TEMPLATE_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.bottomBar.newTemplateTimelineButtonLabel', {
  defaultMessage: 'Create new Timeline template'
});
const OPEN_TIMELINE = exports.OPEN_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.bottomBar.openTimelineButtonLabel', {
  defaultMessage: 'Open Timeline…'
});
const OPEN_TIMELINE_BUTTON = title => _i18n.i18n.translate('xpack.securitySolution.timeline.bottomBar.toggleButtonAriaLabel', {
  values: {
    title
  },
  defaultMessage: 'Open timeline {title}'
});
exports.OPEN_TIMELINE_BUTTON = OPEN_TIMELINE_BUTTON;