"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeEvents = NodeEvents;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _formatted_number = require("../../../common/components/formatted_number");
var _breadcrumbs = require("./breadcrumbs");
var event = _interopRequireWildcard(require("../../../../common/endpoint/models/event"));
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _panel_loading = require("./panel_loading");
var _use_link_props = require("../use_link_props");
var nodeDataModel = _interopRequireWildcard(require("../../models/node_data"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/panels/node_events.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function NodeEvents({
  id,
  nodeID
}) {
  const processEvent = (0, _reactRedux.useSelector)(state => nodeDataModel.firstEvent(selectors.nodeDataForID(state.analyzer[id])(nodeID)));
  const nodeStats = (0, _reactRedux.useSelector)(state => selectors.nodeStats(state.analyzer[id])(nodeID));
  if (processEvent === undefined || nodeStats === undefined) {
    return /*#__PURE__*/_react.default.createElement(_panel_loading.PanelLoading, {
      id: id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 12
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(NodeEventsBreadcrumbs, {
      id: id,
      nodeName: event.processNameSafeVersion(processEvent),
      nodeID: nodeID,
      totalEventCount: nodeStats.total,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(EventCategoryLinks, {
      id: id,
      nodeID: nodeID,
      relatedStats: nodeStats,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }));
  }
}

/**
 * This view gives counts for all the related events of a process grouped by related event type.
 * It should look something like:
 *
 * | Count                  | Event Type                 |
 * | :--------------------- | :------------------------- |
 * | 5                      | DNS                        |
 * | 12                     | Registry                   |
 * | 2                      | Network                    |
 *
 */
// eslint-disable-next-line react/display-name
const EventCategoryLinks = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  nodeID,
  relatedStats
}) {
  const rows = (0, _react.useMemo)(() => {
    return Object.entries(relatedStats.byCategory).map(([eventType, count]) => {
      return {
        eventType,
        count
      };
    });
  }, [relatedStats.byCategory]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'count',
    name: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.table.row.count', {
      defaultMessage: 'Count'
    }),
    'data-test-subj': 'resolver:panel:node-events:event-type-count',
    width: '25%',
    sortable: true,
    render(count) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: count,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
        count: count,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 15
        }
      }));
    }
  }, {
    field: 'eventType',
    name: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.table.row.eventType', {
      defaultMessage: 'Event Type'
    }),
    width: '75%',
    sortable: true,
    render(eventType) {
      return /*#__PURE__*/_react.default.createElement(NodeEventsLink, {
        id: id,
        nodeID: nodeID,
        eventType: eventType,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 13
        }
      }, eventType);
    }
  }], [nodeID, id]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: rows,
    columns: columns,
    sorting: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 10
    }
  });
});

// eslint-disable-next-line react/display-name
const NodeEventsBreadcrumbs = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  nodeID,
  nodeName,
  totalEventCount
}) {
  return /*#__PURE__*/_react.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs: [{
      text: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.processEventCounts.events', {
        defaultMessage: 'Events'
      }),
      ...(0, _use_link_props.useLinkProps)(id, {
        panelView: 'nodes'
      })
    }, {
      text: nodeName,
      ...(0, _use_link_props.useLinkProps)(id, {
        panelView: 'nodeDetail',
        panelParameters: {
          nodeID
        }
      })
    }, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.resolver.panel.relatedCounts.numberOfEventsInCrumb",
        values: {
          totalCount: totalEventCount
        },
        defaultMessage: "{totalCount} Events",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 13
        }
      }),
      ...(0, _use_link_props.useLinkProps)(id, {
        panelView: 'nodeEvents',
        panelParameters: {
          nodeID
        }
      })
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  });
});

// eslint-disable-next-line react/display-name
const NodeEventsLink = /*#__PURE__*/(0, _react.memo)(({
  id,
  nodeID,
  eventType,
  children
}) => {
  const props = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeEventsInCategory',
    panelParameters: {
      nodeID,
      eventCategory: eventType
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "resolver:panel:node-events:event-type-link"
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }), children);
});