"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkStartMigrationCardComplete = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../../../common/siem_migrations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMPLETE_BADGE_TEXT = migrationsCount => _i18n.i18n.translate('xpack.securitySolution.onboarding.siemMigrations.rules.startMigration.completeBadge', {
  defaultMessage: '{migrationsCount} {migrationsCount, plural, one {migration} other {migrations}}',
  values: {
    migrationsCount
  }
});
const checkStartMigrationCardComplete = async ({
  siemMigrations
}) => {
  const missingCapabilities = siemMigrations.rules.getMissingCapabilities('all').map(({
    description
  }) => description);
  let isComplete = false;
  let migrationsCount = 0;
  if (siemMigrations.rules.isAvailable()) {
    const migrationsStats = await siemMigrations.rules.getMigrationsStats();
    isComplete = migrationsStats.some(migrationStats => migrationStats.status === _constants.SiemMigrationTaskStatus.FINISHED);
    migrationsCount = migrationsStats.length;
  }
  return {
    isComplete,
    completeBadgeText: COMPLETE_BADGE_TEXT(migrationsCount),
    metadata: {
      missingCapabilities
    }
  };
};
exports.checkStartMigrationCardComplete = checkStartMigrationCardComplete;