"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KNOWLEDGE_SOURCE_CARD_ITEMS_BY_ID = exports.KNOWLEDGE_SOURCE_CARD_ITEMS = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("./types");
var _types2 = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KNOWLEDGE_SOURCE_CARD_ITEMS = exports.KNOWLEDGE_SOURCE_CARD_ITEMS = [{
  id: _types.KnowledgeSourceCardItemId.install,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCards.install.title', {
    defaultMessage: 'How to add knowledge sources'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCards.install.description', {
    defaultMessage: 'Connect internal data to enrich the AI Assistant’s context'
  }),
  asset: {
    type: _types2.CardAssetType.video,
    source: 'https://ela.st/ai4dsoc-gs1',
    alt: _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCards.install.description', {
      defaultMessage: 'Connect internal data to enrich the AI Assistant’s context'
    })
  }
}, {
  id: _types.KnowledgeSourceCardItemId.create,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCards.create.title', {
    defaultMessage: 'Leveraging knowledge sources in a cyber context'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCards.create.description', {
    defaultMessage: 'Use custom data to improve threat detection and response'
  }),
  asset: {
    type: _types2.CardAssetType.video,
    source: 'https://ela.st/ai4dsoc-gs2',
    alt: _i18n.i18n.translate('xpack.securitySolution.onboarding.knowledgeSourceCards.create.description', {
      defaultMessage: 'Use custom data to improve threat detection and response'
    })
  }
}];
const KNOWLEDGE_SOURCE_CARD_ITEMS_BY_ID = exports.KNOWLEDGE_SOURCE_CARD_ITEMS_BY_ID = Object.fromEntries(KNOWLEDGE_SOURCE_CARD_ITEMS.map(card => [card.id, card]));