"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateProtectionUpdatesNote = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_get_protection_updates_note = require("./use_get_protection_updates_note");
var _kibana = require("../../../../../../common/lib/kibana");
var _resolve_path_variables = require("../../../../../../common/utils/resolve_path_variables");
var _constants = require("../../../../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateProtectionUpdatesNote = ({
  packagePolicyId
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)(payload => http.post((0, _resolve_path_variables.resolvePathVariables)(_constants.PROTECTION_UPDATES_NOTE_ROUTE, {
    package_policy_id: packagePolicyId
  }), {
    version: '2023-10-31',
    body: JSON.stringify(payload)
  }), {
    onSuccess: () => {
      queryClient.invalidateQueries([(0, _use_get_protection_updates_note.getProtectionUpdatesNoteQueryKey)(packagePolicyId)]);
    }
  });
};
exports.useCreateProtectionUpdatesNote = useCreateProtectionUpdatesNote;