"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NGAV_NOTE = exports.NGAV = exports.INTERACTIVE_ONLY = exports.ENDPOINT = exports.EDR_NOTE = exports.EDR_ESSENTIAL = exports.EDR_COMPLETE = exports.DATA_COLLECTION_HELP_TEXT = exports.DATA_COLLECTION = exports.CLOUD_SECURITY = exports.ALL_EVENTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NGAV = exports.NGAV = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionNGAV', {
  defaultMessage: 'Next-Generation Antivirus (NGAV)'
});
const NGAV_NOTE = exports.NGAV_NOTE = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionNGAVNote', {
  defaultMessage: 'Note: advanced protections require a platinum license level.'
});
const EDR_ESSENTIAL = exports.EDR_ESSENTIAL = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionEDREssential', {
  defaultMessage: 'Essential EDR (Endpoint Detection & Response)'
});
const EDR_COMPLETE = exports.EDR_COMPLETE = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionEDRComplete', {
  defaultMessage: 'Complete EDR (Endpoint Detection & Response)'
});
const EDR_NOTE = exports.EDR_NOTE = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionEDRNote', {
  defaultMessage: 'Note: advanced protections require a platinum license, and full response capabilities require an enterprise license.'
});
const DATA_COLLECTION = exports.DATA_COLLECTION = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionDataCollection', {
  defaultMessage: 'Data Collection'
});
const DATA_COLLECTION_HELP_TEXT = exports.DATA_COLLECTION_HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeEndpointDataCollection', {
  defaultMessage: 'Augment your existing anti-virus solution with advanced data collection and detection'
});
const ENDPOINT = exports.ENDPOINT = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOption', {
  defaultMessage: 'Traditional Endpoints (desktops, laptops, virtual machines)'
});
const CLOUD_SECURITY = exports.CLOUD_SECURITY = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.cloudDropdownOption', {
  defaultMessage: 'Cloud Workloads (Linux servers or Kubernetes environments)'
});
const INTERACTIVE_ONLY = exports.INTERACTIVE_ONLY = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.cloudEventFiltersInteractiveOnly', {
  defaultMessage: 'Interactive only'
});
const ALL_EVENTS = exports.ALL_EVENTS = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.cloudEventFiltersAllEvents', {
  defaultMessage: 'All events'
});