"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkUpdateArtifact = useBulkUpdateArtifact;
var _pMap = _interopRequireDefault(require("p-map"));
var _reactQuery = require("@tanstack/react-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_OPTIONS = Object.freeze({});
function useBulkUpdateArtifact(exceptionListApiClient, customOptions = DEFAULT_OPTIONS, options = {
  concurrency: 5
}) {
  return (0, _reactQuery.useMutation)(exceptions => {
    return (0, _pMap.default)(exceptions, exception => {
      return exceptionListApiClient.update(exception);
    }, options);
  }, customOptions);
}