"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PendingActionsSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_get_endpoint_action_list = require("../../../hooks/response_actions/use_get_endpoint_action_list");
var _constants = require("../shared/constants");
var _shared = require("../shared");
var _user_privileges = require("../../../../common/components/user_privileges");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _kibana = require("../../../../common/lib/kibana");
var _hooks = require("../shared/hooks");
var _utils = require("../shared/utils");
var _translations = require("../../../common/translations");
var _constants2 = require("../../../../../common/endpoint/service/response_actions/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console_argument_selectors/pending_actions_selector/pending_actions_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * State for the pending actions selector component
 */

/**
 * A Console Argument Selector component that enables the user to select from available pending actions
 */
const PendingActionsSelector = exports.PendingActionsSelector = /*#__PURE__*/(0, _react.memo)(({
  value,
  valueText,
  onChange,
  store,
  command,
  requestFocus,
  argName,
  argIndex
}) => {
  var _command$commandDefin, _command$commandDefin2;
  const testId = (0, _use_test_id_generator.useTestIdGenerator)(`${command.commandDefinition.name}-${argName}-arg-${argIndex}`);
  const agentType = (_command$commandDefin = command.commandDefinition.meta) === null || _command$commandDefin === void 0 ? void 0 : _command$commandDefin.agentType;
  const endpointId = (_command$commandDefin2 = command.commandDefinition.meta) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.endpointId;
  const userPrivileges = (0, _user_privileges.useUserPrivileges)();
  const state = (0, _hooks.useBaseSelectorState)(store, value);
  const {
    data,
    isLoading,
    error
  } = (0, _use_get_endpoint_action_list.useGetEndpointActionList)({
    agentTypes: agentType,
    agentIds: endpointId,
    page: 1,
    pageSize: 200,
    statuses: ['pending'],
    commands: _constants2.RESPONSE_ACTION_API_COMMANDS_NAMES.filter(action => action !== 'cancel')
  }, {
    enabled: state.isPopoverOpen
  });
  const privilegeChecker = (0, _react.useCallback)(actionCommand => {
    return (0, _shared.checkActionCancelPermission)(actionCommand, userPrivileges.endpointPrivileges);
  }, [userPrivileges.endpointPrivileges]);
  const options = (0, _hooks.usePendingActionsOptions)({
    response: data ? [data] : null,
    selectedValue: value,
    privilegeChecker
  });
  const {
    services: {
      notifications
    }
  } = (0, _kibana.useKibana)();
  const {
    handleOpenPopover,
    handleClosePopover
  } = (0, _hooks.useBaseSelectorHandlers)(state, onChange, value || '', valueText || '');
  const isAwaitingRenderDelay = (0, _hooks.useRenderDelay)();
  (0, _hooks.useFocusManagement)(state.isPopoverOpen, requestFocus);
  (0, _shared.useGenericErrorToast)(error, notifications, _translations.ERROR_LOADING_PENDING_ACTIONS);
  const handleSelection = (0, _react.useCallback)((newOptions, _event, changedOption) => {
    const handler = (0, _utils.createSelectionHandler)(onChange, state);
    handler(newOptions, _event, changedOption);
  }, [onChange, state]);
  const renderOption = (0, _react.useCallback)(option => {
    const hasDescription = 'description' in option && option.description;
    const hasToolTipContent = 'toolTipContent' in option && option.toolTipContent;
    const descriptionText = hasDescription ? String(option.description) : '';
    const toolTipText = hasToolTipContent ? String(option.toolTipContent) : '';
    const content = /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": testId('script'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: _constants.SHARED_TRUNCATION_STYLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": `${option.label}-label`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 17
      }
    }, option.label)), hasDescription ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": `${option.label}-description`,
      color: "subdued",
      size: "s",
      css: {
        width: '100%',
        wordBreak: 'break-word',
        whiteSpace: 'normal'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("small", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 19
      }
    }, descriptionText)) : null), option.disabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "lock",
      size: "s",
      color: "subdued",
      "data-test-subj": `${option.label}-disabled-icon`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 17
      }
    }))));

    // Single tooltip for entire disabled item
    if (option.disabled) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "right",
        content: toolTipText,
        display: "block",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        style: {
          cursor: 'not-allowed'
        },
        tabIndex: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 13
        }
      }, content));
    }
    return content;
  }, [testId]);
  if (isAwaitingRenderDelay || isLoading && !error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": testId('loading'),
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: state.isPopoverOpen,
    offset: 10,
    panelStyle: {
      padding: 0,
      minWidth: _constants.PENDING_ACTIONS_CONFIG.minWidth
    },
    "data-test-subj": testId(),
    closePopover: handleClosePopover,
    panelProps: {
      'data-test-subj': testId('popoverPanel')
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _constants.PENDING_ACTIONS_CONFIG.tooltipText,
      position: "top",
      display: "block",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center",
      gutterSize: "none",
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      onClick: handleOpenPopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      title: valueText,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 15
      }
    }, valueText || _constants.PENDING_ACTIONS_CONFIG.initialLabel)))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 5
    }
  }, state.isPopoverOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    id: _constants.PENDING_ACTIONS_CONFIG.selectableId,
    searchable: true,
    options: options,
    onChange: handleSelection,
    renderOption: renderOption,
    singleSelection: true,
    searchProps: {
      placeholder: valueText || _constants.PENDING_ACTIONS_CONFIG.initialLabel,
      autoFocus: true,
      onKeyDown: _utils.createKeyDownHandler
    },
    listProps: {
      rowHeight: _constants.PENDING_ACTIONS_CONFIG.rowHeight,
      showIcons: true,
      textWrap: 'wrap'
    },
    errorMessage: error ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.baseArgumentSelector.errorLoading",
      defaultMessage: "Error loading pending actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 15
      }
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      margin: 5
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 15
    }
  }, search), list)));
});
PendingActionsSelector.displayName = 'PendingActionsSelector';