"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssistant = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _use_assistant_availability = require("../../../../assistant/use_assistant_availability");
var _helpers = require("../../../../assistant/helpers");
var _translations = require("../../../../common/components/event_details/translations");
var _prompt_contexts = require("../../../../assistant/content/prompt_contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUMMARY_VIEW = _i18n.i18n.translate('xpack.securitySolution.eventDetails.summaryView', {
  defaultMessage: 'summary'
});
const useAssistantNoop = () => ({
  promptContextId: undefined,
  showAssistantOverlay: show => {}
});
/**
 * Hook to return the assistant button visibility and prompt context id
 */
const useAssistant = ({
  dataFormattedForFieldBrowser,
  isAlert
}) => {
  const {
    hasAssistantPrivilege,
    isAssistantEnabled,
    isAssistantVisible
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const {
    basePromptContexts
  } = (0, _elasticAssistant.useAssistantContext)();
  const suggestedUserPrompt = (0, _react.useMemo)(() => {
    var _basePromptContexts$f;
    return (_basePromptContexts$f = basePromptContexts.find(({
      category
    }) => category === (isAlert ? _prompt_contexts.PROMPT_CONTEXT_ALERT_CATEGORY : _prompt_contexts.PROMPT_CONTEXT_EVENT_CATEGORY))) === null || _basePromptContexts$f === void 0 ? void 0 : _basePromptContexts$f.suggestedUserPrompt;
  }, [basePromptContexts, isAlert]);
  const useAssistantHook = hasAssistantPrivilege ? _elasticAssistant.useAssistantOverlay : useAssistantNoop;
  const getPromptContext = (0, _react.useCallback)(async () => (0, _helpers.getRawData)(dataFormattedForFieldBrowser !== null && dataFormattedForFieldBrowser !== void 0 ? dataFormattedForFieldBrowser : []), [dataFormattedForFieldBrowser]);
  const uniqueName = (0, _react.useMemo)(() => {
    var _ref, _dataFormattedForFiel, _dataFormattedForFiel2, _dataFormattedForFiel3, _dataFormattedForFiel4, _dataFormattedForFiel5, _dataFormattedForFiel6, _dataFormattedForFiel7, _dataFormattedForFiel8;
    const ruleName = (_ref = (_dataFormattedForFiel = (_dataFormattedForFiel2 = dataFormattedForFieldBrowser.find(item => item.field === 'rule.name')) === null || _dataFormattedForFiel2 === void 0 ? void 0 : (_dataFormattedForFiel3 = _dataFormattedForFiel2.values) === null || _dataFormattedForFiel3 === void 0 ? void 0 : _dataFormattedForFiel3[0]) !== null && _dataFormattedForFiel !== void 0 ? _dataFormattedForFiel : (_dataFormattedForFiel4 = dataFormattedForFieldBrowser.find(item => item.field === 'kibana.alert.rule.name')) === null || _dataFormattedForFiel4 === void 0 ? void 0 : (_dataFormattedForFiel5 = _dataFormattedForFiel4.values) === null || _dataFormattedForFiel5 === void 0 ? void 0 : _dataFormattedForFiel5[0]) !== null && _ref !== void 0 ? _ref : isAlert ? _translations.ALERT_SUMMARY_CONVERSATION_ID : _translations.EVENT_SUMMARY_CONVERSATION_ID;
    const timestamp = (_dataFormattedForFiel6 = (_dataFormattedForFiel7 = dataFormattedForFieldBrowser.find(item => item.field === '@timestamp')) === null || _dataFormattedForFiel7 === void 0 ? void 0 : (_dataFormattedForFiel8 = _dataFormattedForFiel7.values) === null || _dataFormattedForFiel8 === void 0 ? void 0 : _dataFormattedForFiel8[0]) !== null && _dataFormattedForFiel6 !== void 0 ? _dataFormattedForFiel6 : '';
    return `${ruleName} - ${timestamp}`;
  }, [dataFormattedForFieldBrowser, isAlert]);
  const {
    promptContextId,
    showAssistantOverlay
  } = useAssistantHook(isAlert ? 'alert' : 'event', uniqueName, isAlert ? (0, _translations.ALERT_SUMMARY_CONTEXT_DESCRIPTION)(SUMMARY_VIEW) : (0, _translations.EVENT_SUMMARY_CONTEXT_DESCRIPTION)(SUMMARY_VIEW), getPromptContext, null, suggestedUserPrompt, isAlert ? _translations.ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP : _translations.EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP, isAssistantEnabled);
  return {
    showAssistant: isAssistantEnabled && hasAssistantPrivilege && promptContextId !== null && isAssistantVisible,
    showAssistantOverlay,
    promptContextId: promptContextId || ''
  };
};
exports.useAssistant = useAssistant;