"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrevalenceDetails = exports.PREVALENCE_TAB_ID = exports.LicenseProtectedCell = void 0;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _formatted_number = require("../../../../common/components/formatted_number");
var _use_license = require("../../../../common/hooks/use_license");
var _investigate_in_timeline_button = require("../../../../common/components/event_details/investigate_in_timeline_button");
var _use_prevalence = require("../../shared/hooks/use_prevalence");
var _test_ids = require("./test_ids");
var _context = require("../../shared/context");
var _use_action_cell_data_provider = require("../../../../common/components/event_details/use_action_cell_data_provider");
var _empty_value = require("../../../../common/components/empty_value");
var _types = require("../../../../../common/types");
var _preview_link = require("../../../shared/components/preview_link");
var _cell_actions = require("../../shared/components/cell_actions");
var _user_privileges = require("../../../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/prevalence_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PREVALENCE_TAB_ID = exports.PREVALENCE_TAB_ID = 'prevalence';
const DEFAULT_FROM = 'now-30d';
const DEFAULT_TO = 'now';

/**
 * Component that renders a grey box to indicate the user doesn't have proper license to view the actual data
 */
const LicenseProtectedCell = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_TABLE_UPSELL_CELL_TEST_ID,
    css: {
      height: '16px',
      width: '100%',
      background: euiTheme.colors.lightShade
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  });
};
exports.LicenseProtectedCell = LicenseProtectedCell;
const columns = [{
  field: 'field',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.fieldColumnLabel",
    defaultMessage: "Field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_FIELD_CELL_TEST_ID,
  render: field => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 32
    }
  }, field),
  width: '20%'
}, {
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.valueColumnLabel",
    defaultMessage: "Value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_VALUE_CELL_TEST_ID,
  render: data => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, data.values.map(value => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
    field: data.field,
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
    field: data.field,
    value: value,
    scopeId: data.scopeId,
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_TABLE_PREVIEW_LINK_CELL_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 17
    }
  }, value)))))),
  width: '20%'
}, {
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.prevalence.alertCountColumnTooltip",
      defaultMessage: "Total number of alerts with identical field value pairs.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.alertCountColumnLabel",
    defaultMessage: "Alert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.alertCountColumnCountLabel",
    defaultMessage: "count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  })))),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_ALERT_COUNT_CELL_TEST_ID,
  render: data => {
    const dataProviders = data.values.map(value => (0, _use_action_cell_data_provider.getDataProvider)(data.field, `timeline-indicator-${data.field}-${value}`, value));
    if (data.alertCount === 0) {
      return (0, _empty_value.getEmptyTagValue)();
    }
    const alertCount = /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: data.alertCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 26
      }
    });
    if (!data.canUseTimeline) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        "data-test-subj": _test_ids.PREVALENCE_DETAILS_TABLE_COUNT_TEXT_BUTTON_TEST_ID,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 11
        }
      }, alertCount);
    }
    return /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_button.InvestigateInTimelineButton, {
      asEmptyButton: true,
      dataProviders: dataProviders,
      filters: [],
      timeRange: {
        kind: 'absolute',
        from: data.from,
        to: data.to
      },
      "data-test-subj": _test_ids.PREVALENCE_DETAILS_TABLE_INVESTIGATE_IN_TIMELINE_BUTTON_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 9
      }
    }, alertCount);
  },
  width: '10%'
}, {
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.prevalence.documentCountColumnTooltip",
      defaultMessage: "Total number of event documents with identical field value pairs.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.documentCountColumnLabel",
    defaultMessage: "Document",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.documentCountColumnCountLabel",
    defaultMessage: "count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 13
    }
  })))),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_DOC_COUNT_CELL_TEST_ID,
  render: data => {
    const dataProviders = data.values.map(value => ({
      ...(0, _use_action_cell_data_provider.getDataProvider)(data.field, `timeline-indicator-${data.field}-${value}`, value),
      and: [(0, _use_action_cell_data_provider.getDataProviderAnd)('event.kind', `timeline-indicator-event.kind-not-signal`, 'signal', _types.IS_OPERATOR, true)]
    }));
    if (data.docCount === 0) {
      return (0, _empty_value.getEmptyTagValue)();
    }
    const docCount = /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: data.docCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 24
      }
    });
    if (!data.canUseTimeline) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        "data-test-subj": _test_ids.PREVALENCE_DETAILS_TABLE_COUNT_TEXT_BUTTON_TEST_ID,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 11
        }
      }, docCount);
    }
    return /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_button.InvestigateInTimelineButton, {
      asEmptyButton: true,
      dataProviders: dataProviders,
      filters: [],
      timeRange: {
        kind: 'absolute',
        from: data.from,
        to: data.to
      },
      keepDataView: true // changing dataview from only detections to include non-alerts docs
      ,
      "data-test-subj": _test_ids.PREVALENCE_DETAILS_TABLE_INVESTIGATE_IN_TIMELINE_BUTTON_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 9
      }
    }, docCount);
  },
  width: '10%'
}, {
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.prevalence.hostPrevalenceColumnTooltip",
      defaultMessage: "Percentage of unique hosts with identical field value pairs.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.hostPrevalenceColumnLabel",
    defaultMessage: "Host",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.hostPrevalenceColumnCountLabel",
    defaultMessage: "prevalence",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 13
    }
  })))),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_HOST_PREVALENCE_CELL_TEST_ID,
  render: data => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.isPlatinumPlus ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 11
    }
  }, `${Math.round(data.hostPrevalence * 100)}%`) : /*#__PURE__*/_react.default.createElement(LicenseProtectedCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 11
    }
  })),
  width: '10%'
}, {
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.prevalence.userPrevalenceColumnTooltip",
      defaultMessage: "Percentage of unique users with identical field value pairs.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.userPrevalenceColumnLabel",
    defaultMessage: "User",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.userPrevalenceColumnCountLabel",
    defaultMessage: "prevalence",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 13
    }
  })))),
  'data-test-subj': _test_ids.PREVALENCE_DETAILS_TABLE_USER_PREVALENCE_CELL_TEST_ID,
  render: data => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.isPlatinumPlus ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 11
    }
  }, `${Math.round(data.userPrevalence * 100)}%`) : /*#__PURE__*/_react.default.createElement(LicenseProtectedCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 11
    }
  })),
  width: '10%'
}];

/**
 * Prevalence table displayed in the document details expandable flyout left section under the Insights tab
 */
const PrevalenceDetails = () => {
  const {
    dataFormattedForFieldBrowser,
    investigationFields,
    scopeId
  } = (0, _context.useDocumentDetailsContext)();
  const {
    timelinePrivileges: {
      read: canUseTimeline
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();

  // these two are used by the usePrevalence hook to fetch the data
  const [start, setStart] = (0, _react.useState)(DEFAULT_FROM);
  const [end, setEnd] = (0, _react.useState)(DEFAULT_TO);

  // these two are used to pass to timeline
  const [absoluteStart, setAbsoluteStart] = (0, _react.useState)((_datemath.default.parse(DEFAULT_FROM) || new Date()).toISOString());
  const [absoluteEnd, setAbsoluteEnd] = (0, _react.useState)((_datemath.default.parse(DEFAULT_TO) || new Date()).toISOString());

  // TODO update the logic to use a single set of start/end dates
  //  currently as we're using this InvestigateInTimelineButton component we need to pass the timeRange
  //  as an AbsoluteTimeRange, which requires from/to values
  const onTimeChange = ({
    start: s,
    end: e,
    isInvalid
  }) => {
    if (isInvalid) return;
    setStart(s);
    setEnd(e);
    const from = _datemath.default.parse(s);
    if (from && from.isValid()) {
      setAbsoluteStart(from.toISOString());
    }
    const to = _datemath.default.parse(e);
    if (to && to.isValid()) {
      setAbsoluteEnd(to.toISOString());
    }
  };
  const {
    loading,
    error,
    data
  } = (0, _use_prevalence.usePrevalence)({
    dataFormattedForFieldBrowser,
    investigationFields,
    interval: {
      from: start,
      to: end
    }
  });

  // add timeRange to pass it down to timeline and license to drive the rendering of the last 2 prevalence columns
  const items = (0, _react.useMemo)(() => data.map(item => ({
    ...item,
    from: absoluteStart,
    to: absoluteEnd,
    isPlatinumPlus,
    scopeId,
    canUseTimeline
  })), [data, absoluteStart, absoluteEnd, canUseTimeline, isPlatinumPlus, scopeId]);
  const upsell = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_UPSELL_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalence.tableAlertUpsellDescription",
    defaultMessage: "Host and user prevalence are only available with a {subscription}.",
    values: {
      subscription: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/pricing/",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 417,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.left.insights.prevalence.tableAlertUpsellLinkText",
        defaultMessage: "Platinum or higher subscription",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 418,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 427,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !error && !isPlatinumPlus && upsell, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: start,
    end: end,
    onTimeChange: onTimeChange,
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_DATE_PICKER_TEST_ID,
    width: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: error ? [] : items,
    columns: columns,
    loading: loading,
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_TABLE_TEST_ID,
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.prevalence.noDataDescription",
      defaultMessage: "No prevalence data available.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 449,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 443,
      columnNumber: 9
    }
  })));
};
exports.PrevalenceDetails = PrevalenceDetails;
PrevalenceDetails.displayName = 'PrevalenceDetails';