"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsListCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _edit_exception_flyout = require("../../../detection_engine/rule_exceptions/components/edit_exception_flyout");
var _add_exception_flyout = require("../../../detection_engine/rule_exceptions/components/add_exception_flyout");
var _title_badge = require("../title_badge");
var i18n = _interopRequireWildcard(require("../../translations"));
var _list_exception_items = require("../list_exception_items");
var _hooks = require("../../hooks");
var _use_exceptions_list = require("../../hooks/use_exceptions_list.card");
var _manage_rules = require("../manage_rules");
var _expired_exceptions_list_items_modal = require("../expired_exceptions_list_items_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/exceptions/components/exceptions_list_card/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExceptionPanel = (0, _styled.default)(_eui.EuiPanel)`
  margin: ${({
  theme: {
    euiTheme: {
      size
    }
  }
}) => `-${size.s} ${size.m} 0 ${size.m}`};
`;
const ListHeaderContainer = (0, _styled.default)(_eui.EuiFlexGroup)`
  padding: ${({
  theme
}) => theme.euiTheme.size.s};
  text-align: initial;
`;
const ExceptionsListCard = exports.ExceptionsListCard = /*#__PURE__*/(0, _react.memo)(({
  exceptionsList,
  handleDelete,
  handleExport,
  handleDuplicate,
  readOnly
}) => {
  const {
    linkedRules,
    showManageRulesFlyout,
    showManageButtonLoader,
    disableManageButton,
    onManageRules,
    onSaveManageRules,
    onCancelManageRules,
    onRuleSelectionChange
  } = (0, _hooks.useListDetailsView)(exceptionsList.list_id);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const panelShadow = (0, _eui.useEuiShadow)();
  const euiAccordionStyles = (0, _react.useMemo)(() => (0, _react2.css)`
        .euiAccordion__buttonContent {
          flex: 1 1 auto;
          cursor: pointer;
        }
        > .euiAccordion__triggerWrapper {
          z-index: 100;
          position: relative;
          border-radius: ${euiTheme.border.radius.medium};
          padding: ${euiTheme.size.base};
          ${panelShadow}
        }
      `, [euiTheme.border.radius.medium, euiTheme.size.base, panelShadow]);
  const {
    listId,
    listName,
    listType,
    createdAt,
    createdBy,
    exceptions,
    pagination,
    ruleReferences,
    toggleAccordion,
    openAccordionId,
    menuActionItems,
    listDescription,
    exceptionItemsCount,
    onEditExceptionItem,
    onDeleteException,
    onPaginationChange,
    setToggleAccordion,
    exceptionViewerStatus,
    showAddExceptionFlyout,
    showEditExceptionFlyout,
    exceptionToEdit,
    onAddExceptionClick,
    handleConfirmExceptionFlyout,
    handleCancelExceptionItemFlyout,
    goToExceptionDetail,
    emptyViewerTitle,
    emptyViewerBody,
    emptyViewerButtonText,
    handleCancelExpiredExceptionsModal,
    handleConfirmExpiredExceptionsModal,
    showIncludeExpiredExceptionsModal
  } = (0, _use_exceptions_list.useExceptionsListCard)({
    exceptionsList,
    handleExport,
    handleDelete,
    handleDuplicate,
    handleManageRules: onManageRules
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    css: euiAccordionStyles,
    id: openAccordionId,
    buttonElement: "div",
    onToggle: () => setToggleAccordion(!toggleAccordion),
    buttonContent: /*#__PURE__*/_react.default.createElement(ListHeaderContainer, {
      gutterSize: "m",
      alignItems: "center",
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      key: listId,
      alignItems: "flexStart",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "exception-list-name",
      onClick: goToExceptionDetail,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 23
      }
    }, listName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 23
      }
    }, listDescription))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexEnd",
      wrap: true,
      responsive: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_title_badge.TitleBadge, {
      title: i18n.DATE_CREATED,
      badgeString: createdAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_title_badge.TitleBadge, {
      title: i18n.CREATED_BY,
      badgeString: createdBy,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_title_badge.TitleBadge, {
      title: i18n.EXCEPTIONS,
      badgeString: exceptionItemsCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "exceptionListCardLinkedRulesBadge",
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_title_badge.TitleBadge, {
      title: i18n.RULES,
      badgeString: linkedRules.length.toString(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 21
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.HeaderMenu, {
      disableActions: readOnly,
      dataTestSubj: "sharedListOverflowCard",
      actions: menuActionItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 17
      }
    }))),
    "data-test-subj": `exceptionsManagementListCard-${listId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ExceptionPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_list_exception_items.ListExceptionItems, {
    isReadOnly: readOnly,
    exceptions: exceptions,
    listType: exceptionsList.type,
    pagination: pagination,
    hideUtility: true,
    viewerStatus: exceptionViewerStatus,
    ruleReferences: ruleReferences,
    onDeleteException: onDeleteException,
    onEditExceptionItem: onEditExceptionItem,
    onPaginationChange: onPaginationChange,
    onCreateExceptionListItem: onAddExceptionClick,
    lastUpdated: null,
    emptyViewerTitle: emptyViewerTitle,
    emptyViewerBody: emptyViewerBody,
    emptyViewerButtonText: emptyViewerButtonText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  }))), showAddExceptionFlyout ? /*#__PURE__*/_react.default.createElement(_add_exception_flyout.AddExceptionFlyout, {
    rules: null,
    isBulkAction: false,
    isEndpointItem: listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT,
    sharedListToAddTo: [exceptionsList],
    onCancel: handleCancelExceptionItemFlyout,
    onConfirm: handleConfirmExceptionFlyout,
    "data-test-subj": "addExceptionItemFlyoutInSharedLists",
    showAlertCloseOptions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 11
    }
  }) : null, showEditExceptionFlyout && exceptionToEdit ? /*#__PURE__*/_react.default.createElement(_edit_exception_flyout.EditExceptionFlyout, {
    list: exceptionsList,
    itemToEdit: exceptionToEdit,
    showAlertCloseOptions: true,
    openedFromListDetailPage: true,
    onCancel: handleCancelExceptionItemFlyout,
    onConfirm: handleConfirmExceptionFlyout,
    "data-test-subj": "editExceptionItemFlyoutInSharedLists",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  }) : null, showManageRulesFlyout ? /*#__PURE__*/_react.default.createElement(_manage_rules.ManageRules, {
    linkedRules: linkedRules,
    showButtonLoader: showManageButtonLoader,
    saveIsDisabled: disableManageButton,
    onSave: onSaveManageRules,
    onCancel: onCancelManageRules,
    onRuleSelectionChange: onRuleSelectionChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 11
    }
  }) : null, showIncludeExpiredExceptionsModal ? /*#__PURE__*/_react.default.createElement(_expired_exceptions_list_items_modal.IncludeExpiredExceptionsModal, {
    handleCloseModal: handleCancelExpiredExceptionsModal,
    onModalConfirm: handleConfirmExpiredExceptionsModal,
    action: showIncludeExpiredExceptionsModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 11
    }
  }) : null);
});
ExceptionsListCard.displayName = 'ExceptionsListCard';