"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostRiskScoreColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cell_actions = require("../../../common/components/cell_actions");
var _empty_value = require("../../../common/components/empty_value");
var _links = require("../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _model = require("../../../explore/hosts/store/model");
var _search_strategy = require("../../../../common/search_strategy");
var _types = require("../../../../common/entity_analytics/types");
var _common = require("../severity/common");
var _translations2 = require("../risk_score/translations");
var _constants = require("../risk_score/constants");
var _formatted_date = require("../../../common/components/formatted_date");
var _common2 = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/host_risk_score_table/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getHostRiskScoreColumns = ({
  dispatchSeverityUpdate
}) => [{
  field: 'host.name',
  name: i18n.HOST_NAME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  width: '35%',
  render: hostName => {
    if (hostName != null && hostName.length > 0) {
      return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        data: {
          value: hostName,
          field: 'host.name'
        },
        metadata: {
          telemetry: _constants.CELL_ACTIONS_TELEMETRY
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
        hostName: hostName,
        hostTab: _model.HostsTableType.risk,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 13
        }
      }));
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.timestamp,
  name: i18n.LAST_UPDATED,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: lastSeen => {
    if (lastSeen != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        value: lastSeen,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 16
        }
      });
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.hostRiskScore,
  name: i18n.HOST_RISK_SCORE,
  truncateText: true,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: riskScore => {
    if (riskScore != null) {
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "risk-score-truncate",
        title: `${riskScore}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 11
        }
      }, (0, _common2.formatRiskScore)(riskScore));
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.hostRisk,
  name: (0, _translations2.ENTITY_RISK_LEVEL)(_types.EntityType.host),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  render: risk => {
    if (risk != null) {
      return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
        toolTipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => dispatchSeverityUpdate(risk),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 104,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 17
          }
        }, i18n.VIEW_HOSTS_BY_SEVERITY(risk.toLowerCase()))),
        severity: risk,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 11
        }
      });
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}];
exports.getHostRiskScoreColumns = getHostRiskScoreColumns;