"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupedAlertsTable = exports.DEFAULT_GROUP_STATS_RENDERER = exports.DEFAULT_GROUP_STATS_AGGREGATION = exports.DEFAULT_GROUPING_OPTIONS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _grouping = require("@kbn/grouping");
var _fp = require("lodash/fp");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _selectors = require("../../../common/store/grouping/selectors");
var _use_selector = require("../../../common/hooks/use_selector");
var _actions = require("../../../common/store/grouping/actions");
var _unit = require("../../../common/components/toolbar/unit");
var _kibana = require("../../../common/lib/kibana");
var _alerts_sub_grouping = require("./alerts_sub_grouping");
var _telemetry = require("../../../common/lib/telemetry");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/alerts_grouping.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PAGE_SIZE = 25;
const DEFAULT_PAGE_INDEX = 0;
const MAX_GROUPING_LEVELS = 3;
const DEFAULT_GROUPING_OPTIONS = exports.DEFAULT_GROUPING_OPTIONS = [];

/**
 * This is used as default behavior if no group renderer is passed via props.
 * This will render the number of alerts.
 * It's paired with the DEFAULT_GROUP_STATS_AGGREGATION which retrieves the aggregation data.
 */
const DEFAULT_GROUP_STATS_RENDERER = (_, bucket) => [{
  title: i18n.STATS_GROUP_ALERTS,
  badge: {
    value: bucket.doc_count,
    width: 50,
    color: '#a83632'
  }
}];
/**
 * This is used as default behavior if no group aggregations is passed via props.
 * This will render retrieve the values to render the DEFAULT_GROUP_STATS_RENDERER above.
 */
exports.DEFAULT_GROUP_STATS_RENDERER = DEFAULT_GROUP_STATS_RENDERER;
const DEFAULT_GROUP_STATS_AGGREGATION = () => [{
  unitsCount: {
    cardinality: {
      field: 'kibana.alert.uuid'
    }
  }
}];
exports.DEFAULT_GROUP_STATS_AGGREGATION = DEFAULT_GROUP_STATS_AGGREGATION;
const useStorage = (storage, tableId) => (0, _react.useMemo)(() => ({
  getStoragePageSize: () => {
    const pageSizes = storage.get(`grouping-table-${tableId}`);
    if (!pageSizes) {
      return Array(MAX_GROUPING_LEVELS).fill(DEFAULT_PAGE_SIZE);
    }
    return pageSizes;
  },
  setStoragePageSize: pageSizes => {
    storage.set(`grouping-table-${tableId}`, pageSizes);
  }
}), [storage, tableId]);
const GroupedAlertsTableComponent = props => {
  var _props$dataView2, _props$dataViewSpec2, _props$dataView5, _props$accordionExtra2, _props$accordionExtra4;
  const dispatch = (0, _reactRedux.useDispatch)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    services: {
      storage,
      telemetry
    }
  } = (0, _kibana.useKibana)();
  const {
    getStoragePageSize,
    setStoragePageSize
  } = useStorage(storage, props.tableId);
  const {
    onGroupChange,
    onGroupToggle
  } = (0, _react.useMemo)(() => ({
    onGroupChange: ({
      groupByField,
      tableId
    }) => {
      telemetry.reportEvent(_telemetry.AlertsEventTypes.AlertsGroupingChanged, {
        groupByField,
        tableId
      });
    },
    onGroupToggle: param => telemetry.reportEvent(_telemetry.AlertsEventTypes.AlertsGroupingToggled, {
      ...param,
      tableId: param.groupingId
    })
  }), [telemetry]);
  const onOptionsChange = (0, _react.useCallback)(options => {
    dispatch((0, _actions.updateGroups)({
      tableId: props.tableId,
      options
    }));
  }, [dispatch, props.tableId]);
  const fields = (0, _react.useMemo)(() => {
    var _props$dataView;
    return newDataViewPickerEnabled ? ((_props$dataView = props.dataView) === null || _props$dataView === void 0 ? void 0 : _props$dataView.fields.map(field => field.spec)) || [] : Object.values(props.dataViewSpec.fields || {});
  }, [newDataViewPickerEnabled, (_props$dataView2 = props.dataView) === null || _props$dataView2 === void 0 ? void 0 : _props$dataView2.fields, props.dataViewSpec.fields]);
  const runtimeMappings = (0, _react.useMemo)(() => {
    var _props$dataView3, _props$dataViewSpec;
    return newDataViewPickerEnabled ? (_props$dataView3 = props.dataView) === null || _props$dataView3 === void 0 ? void 0 : _props$dataView3.getRuntimeMappings() : (_props$dataViewSpec = props.dataViewSpec) === null || _props$dataViewSpec === void 0 ? void 0 : _props$dataViewSpec.runtimeFieldMap;
  }, [newDataViewPickerEnabled, props.dataView, (_props$dataViewSpec2 = props.dataViewSpec) === null || _props$dataViewSpec2 === void 0 ? void 0 : _props$dataViewSpec2.runtimeFieldMap]);
  const dataViewTitle = (0, _react.useMemo)(() => {
    var _props$dataView4;
    return newDataViewPickerEnabled ? (_props$dataView4 = props.dataView) === null || _props$dataView4 === void 0 ? void 0 : _props$dataView4.title : props.dataViewSpec.title;
  }, [newDataViewPickerEnabled, (_props$dataView5 = props.dataView) === null || _props$dataView5 === void 0 ? void 0 : _props$dataView5.title, props.dataViewSpec.title]);
  const groupingOptions = (0, _react.useMemo)(() => props.defaultGroupingOptions || DEFAULT_GROUPING_OPTIONS, [props.defaultGroupingOptions]);
  const groupStatsRenderer = (0, _react.useMemo)(() => {
    var _props$accordionExtra;
    return ((_props$accordionExtra = props.accordionExtraActionGroupStats) === null || _props$accordionExtra === void 0 ? void 0 : _props$accordionExtra.renderer) || DEFAULT_GROUP_STATS_RENDERER;
  }, [(_props$accordionExtra2 = props.accordionExtraActionGroupStats) === null || _props$accordionExtra2 === void 0 ? void 0 : _props$accordionExtra2.renderer]);
  const groupStatusAggregations = (0, _react.useMemo)(() => {
    var _props$accordionExtra3;
    return ((_props$accordionExtra3 = props.accordionExtraActionGroupStats) === null || _props$accordionExtra3 === void 0 ? void 0 : _props$accordionExtra3.aggregations) || DEFAULT_GROUP_STATS_AGGREGATION;
  }, [(_props$accordionExtra4 = props.accordionExtraActionGroupStats) === null || _props$accordionExtra4 === void 0 ? void 0 : _props$accordionExtra4.aggregations]);
  const {
    getGrouping,
    selectedGroups,
    setSelectedGroups
  } = (0, _grouping.useGrouping)({
    componentProps: {
      groupPanelRenderer: props.accordionButtonContent,
      getGroupStats: groupStatsRenderer,
      onGroupToggle,
      unit: _unit.defaultUnit
    },
    defaultGroupingOptions: groupingOptions,
    fields,
    groupingId: props.tableId,
    maxGroupingLevels: MAX_GROUPING_LEVELS,
    onGroupChange,
    onOptionsChange,
    tracker: _telemetry.track
  });
  const groupId = (0, _react.useMemo)(() => (0, _selectors.groupIdSelector)(), []);
  const groupInRedux = (0, _use_selector.useDeepEqualSelector)(state => groupId(state, props.tableId));
  (0, _react.useEffect)(() => {
    // only ever set to `none` - siem only handles group selector when `none` is selected
    if ((0, _grouping.isNoneGroup)(selectedGroups)) {
      // set active groups from selected groups
      dispatch((0, _actions.updateGroups)({
        activeGroups: selectedGroups,
        tableId: props.tableId
      }));
    }
  }, [dispatch, props.tableId, selectedGroups]);
  (0, _react.useEffect)(() => {
    if (groupInRedux != null && !(0, _grouping.isNoneGroup)(groupInRedux.activeGroups)) {
      // set selected groups from active groups
      setSelectedGroups(groupInRedux.activeGroups);
    }
  }, [groupInRedux, setSelectedGroups]);
  const [pageIndex, setPageIndex] = (0, _react.useState)(Array(MAX_GROUPING_LEVELS).fill(DEFAULT_PAGE_INDEX));
  const [pageSize, setPageSize] = (0, _react.useState)(getStoragePageSize);
  const resetAllPagination = (0, _react.useCallback)(() => {
    setPageIndex(curr => curr.map(() => DEFAULT_PAGE_INDEX));
  }, []);
  const setPageVar = (0, _react.useCallback)((newNumber, groupingLevel, pageType) => {
    if (pageType === 'index') {
      setPageIndex(currentIndex => {
        const newArr = [...currentIndex];
        newArr[groupingLevel] = newNumber;
        return newArr;
      });
    }
    if (pageType === 'size') {
      setPageSize(currentIndex => {
        const newArr = [...currentIndex];
        newArr[groupingLevel] = newNumber;
        setStoragePageSize(newArr);
        return newArr;
      });
      // set page index to 0 when page size is changed
      setPageIndex(currentIndex => {
        const newArr = [...currentIndex];
        newArr[groupingLevel] = 0;
        return newArr;
      });
    }
  }, [setStoragePageSize]);
  const paginationResetTriggers = (0, _react.useRef)({
    defaultFilters: props.defaultFilters,
    globalFilters: props.globalFilters,
    globalQuery: props.globalQuery,
    selectedGroups
  });
  (0, _react.useEffect)(() => {
    const triggers = {
      defaultFilters: props.defaultFilters,
      globalFilters: props.globalFilters,
      globalQuery: props.globalQuery,
      selectedGroups
    };
    if (!(0, _fp.isEqual)(paginationResetTriggers.current, triggers)) {
      resetAllPagination();
      paginationResetTriggers.current = triggers;
    }
  }, [props.defaultFilters, props.globalFilters, props.globalQuery, resetAllPagination, selectedGroups]);
  const getLevel = (0, _react.useCallback)((level, selectedGroup, parentGroupingFilter) => {
    var _pageIndex$level, _pageSize$level;
    let rcc;
    if (level < selectedGroups.length - 1) {
      rcc = groupingFilters => {
        return getLevel(level + 1, selectedGroups[level + 1],
        // stringify because if the filter is passed as an object, it will cause unnecessary re-rendering
        JSON.stringify([...groupingFilters, ...(parentGroupingFilter ? JSON.parse(parentGroupingFilter) : [])]));
      };
    } else {
      rcc = groupingFilters => {
        return props.renderChildComponent([...groupingFilters, ...(parentGroupingFilter ? JSON.parse(parentGroupingFilter) : [])]);
      };
    }
    const resetGroupChildrenPagination = parentLevel => {
      setPageIndex(allPages => {
        const resetPages = allPages.splice(parentLevel + 1, allPages.length);
        return [...allPages, ...resetPages.map(() => DEFAULT_PAGE_INDEX)];
      });
    };
    return /*#__PURE__*/_react.default.createElement(_alerts_sub_grouping.GroupedSubLevel, (0, _extends2.default)({}, props, {
      getGrouping: getGrouping,
      groupingLevel: level,
      groupStatsAggregations: groupStatusAggregations,
      groupTakeActionItems: props.groupTakeActionItems,
      onGroupClose: () => resetGroupChildrenPagination(level),
      pageIndex: (_pageIndex$level = pageIndex[level]) !== null && _pageIndex$level !== void 0 ? _pageIndex$level : DEFAULT_PAGE_INDEX,
      pageSize: (_pageSize$level = pageSize[level]) !== null && _pageSize$level !== void 0 ? _pageSize$level : DEFAULT_PAGE_SIZE,
      parentGroupingFilter: parentGroupingFilter,
      renderChildComponent: rcc,
      runtimeMappings: runtimeMappings,
      selectedGroup: selectedGroup,
      setPageIndex: newIndex => setPageVar(newIndex, level, 'index'),
      setPageSize: newSize => setPageVar(newSize, level, 'size'),
      signalIndexName: dataViewTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 350,
        columnNumber: 9
      }
    }));
  }, [dataViewTitle, getGrouping, groupStatusAggregations, pageIndex, pageSize, props, runtimeMappings, selectedGroups, setPageVar]);
  if ((0, _fp.isEmpty)(dataViewTitle)) {
    return null;
  }
  return getLevel(0, selectedGroups[0]);
};
const GroupedAlertsTable = exports.GroupedAlertsTable = /*#__PURE__*/_react.default.memo(GroupedAlertsTableComponent);