"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPGRADE_RULE_SUCCESS = exports.UPGRADE_RULE_SKIPPED = exports.UPGRADE_RULE_FAILED = exports.RULE_UPGRADE_FAILED = exports.RULE_REVERT_FAILED_CONCURRENCY_MESSAGE = exports.RULE_REVERT_FAILED = exports.RULE_INSTALLATION_FAILED = exports.REVERT_RULE_SUCCESS = exports.REVERT_RULE_SKIPPED = exports.INSTALL_RULE_SUCCESS = exports.INSTALL_RULE_SKIPPED = exports.INSTALL_RULE_FAILED = exports.ALL_REVERT_RULES_SKIPPED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_INSTALLATION_FAILED = exports.RULE_INSTALLATION_FAILED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.ruleInstallationFailed', {
  defaultMessage: 'Rule installation failed'
});
const INSTALL_RULE_SUCCESS = succeeded => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.installRuleSuccess', {
  defaultMessage: '{succeeded, plural, one {# rule} other {# rules}} installed successfully',
  values: {
    succeeded
  }
});
exports.INSTALL_RULE_SUCCESS = INSTALL_RULE_SUCCESS;
const INSTALL_RULE_SKIPPED = skipped => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.installRuleSkipped', {
  defaultMessage: '{skipped, plural, one {# rule was} other {# rules were}} skipped during installation.',
  values: {
    skipped
  }
});
exports.INSTALL_RULE_SKIPPED = INSTALL_RULE_SKIPPED;
const INSTALL_RULE_FAILED = failed => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.installRuleFailed', {
  defaultMessage: '{failed, plural, one {# rule} other {# rules}} failed to install',
  values: {
    failed
  }
});
exports.INSTALL_RULE_FAILED = INSTALL_RULE_FAILED;
const RULE_UPGRADE_FAILED = exports.RULE_UPGRADE_FAILED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.ruleUpgradeFailed', {
  defaultMessage: 'Rule update failed'
});
const UPGRADE_RULE_SUCCESS = succeeded => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.upgradeRuleSuccess', {
  defaultMessage: '{succeeded, plural, one {# rule} other {# rules}} updated successfully',
  values: {
    succeeded
  }
});
exports.UPGRADE_RULE_SUCCESS = UPGRADE_RULE_SUCCESS;
const UPGRADE_RULE_SKIPPED = skipped => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.upgradeRuleSkipped', {
  defaultMessage: '{skipped, plural, one {# rule was} other {# rules were}} skipped during update.',
  values: {
    skipped
  }
});
exports.UPGRADE_RULE_SKIPPED = UPGRADE_RULE_SKIPPED;
const UPGRADE_RULE_FAILED = failed => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.upgradeRuleFailed', {
  defaultMessage: '{failed, plural, one {# rule} other {# rules}} failed to update',
  values: {
    failed
  }
});
exports.UPGRADE_RULE_FAILED = UPGRADE_RULE_FAILED;
const RULE_REVERT_FAILED = exports.RULE_REVERT_FAILED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.ruleRevertFailed', {
  defaultMessage: 'Rule reversion failed'
});
const RULE_REVERT_FAILED_CONCURRENCY_MESSAGE = exports.RULE_REVERT_FAILED_CONCURRENCY_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.ruleRevertFailedConcurrencyMessage', {
  defaultMessage: 'Something in the rule object has changed before reversion was completed. Please review the updated diff and try again.'
});
const REVERT_RULE_SUCCESS = succeeded => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.revertRuleSuccess', {
  defaultMessage: '{succeeded, plural, one {# rule} other {# rules}} reverted successfully.',
  values: {
    succeeded
  }
});
exports.REVERT_RULE_SUCCESS = REVERT_RULE_SUCCESS;
const REVERT_RULE_SKIPPED = skipped => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.revertRuleSkipped', {
  defaultMessage: '{skipped, plural, one {# rule was} other {# rules were}} skipped during reversion.',
  values: {
    skipped
  }
});
exports.REVERT_RULE_SKIPPED = REVERT_RULE_SKIPPED;
const ALL_REVERT_RULES_SKIPPED = skipped => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.prebuiltRules.toast.allRevertRuleSkipped', {
  defaultMessage: '{skipped, plural, one {# rule was} other {All # rules were}} skipped during reversion.',
  values: {
    skipped
  }
});
exports.ALL_REVERT_RULES_SKIPPED = ALL_REVERT_RULES_SKIPPED;