"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFetchCoverageOverviewQuery = exports.useFetchCoverageOverviewQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _react = require("react");
var i18n = _interopRequireWildcard(require("../../../rule_management_ui/pages/coverage_overview/translations"));
var _detection_engine = require("../../../../../common/api/detection_engine");
var _api = require("../api");
var _build_coverage_overview_dashboard_model = require("../../logic/coverage_overview/build_coverage_overview_dashboard_model");
var _constants = require("./constants");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COVERAGE_OVERVIEW_QUERY_KEY = ['POST', _detection_engine.RULE_MANAGEMENT_COVERAGE_OVERVIEW_URL];

/**
 * A wrapper around useQuery provides default values to the underlying query,
 * like query key, abortion signal, and error handler.
 *
 * @param filter - coverage overview filter, see CoverageOverviewFilter type
 * @param options - react-query options
 * @returns useQuery result
 */
const useFetchCoverageOverviewQuery = (filter = {}, options) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useQuery)([...COVERAGE_OVERVIEW_QUERY_KEY, filter], async ({
    signal
  }) => {
    const response = await (0, _api.fetchCoverageOverview)({
      signal,
      filter
    });
    return (0, _build_coverage_overview_dashboard_model.buildCoverageOverviewDashboardModel)(response);
  }, {
    ..._constants.DEFAULT_QUERY_OPTIONS,
    ...options,
    onError: error => {
      addError(error, {
        title: i18n.COVERAGE_OVERVIEW_FETCH_ERROR_TITLE
      });
    }
  });
};

/**
 * We should use this hook to invalidate the coverage overview cache. For example, rule
 * mutations that affect rule set size, like creation or deletion, should lead
 * to cache invalidation.
 *
 * @returns A coverage overview cache invalidation callback
 */
exports.useFetchCoverageOverviewQuery = useFetchCoverageOverviewQuery;
const useInvalidateFetchCoverageOverviewQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(COVERAGE_OVERVIEW_QUERY_KEY, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFetchCoverageOverviewQuery = useInvalidateFetchCoverageOverviewQuery;