"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFetchPrebuiltRulesUpgradeReviewQuery = exports.useFetchPrebuiltRulesUpgradeReviewQuery = exports.REVIEW_RULE_UPGRADE_QUERY_KEY = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _api = require("../../api");
var _urls = require("../../../../../../common/api/detection_engine/prebuilt_rules/urls");
var _constants = require("../constants");
var _retry_on_rate_limited_error = require("./retry_on_rate_limited_error");
var _capped_exponential_backoff = require("./capped_exponential_backoff");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REVIEW_RULE_UPGRADE_QUERY_KEY = exports.REVIEW_RULE_UPGRADE_QUERY_KEY = ['POST', _urls.REVIEW_RULE_UPGRADE_URL];
const useFetchPrebuiltRulesUpgradeReviewQuery = (request, options) => {
  return (0, _reactQuery.useQuery)([...REVIEW_RULE_UPGRADE_QUERY_KEY, request], async ({
    signal
  }) => {
    const response = await (0, _api.reviewRuleUpgrade)({
      signal,
      request
    });
    return response;
  }, {
    ..._constants.DEFAULT_QUERY_OPTIONS,
    ...options,
    retry: _retry_on_rate_limited_error.retryOnRateLimitedError,
    retryDelay: _capped_exponential_backoff.cappedExponentialBackoff
  });
};

/**
 * We should use this hook to invalidate the prebuilt rules to upgrade cache. For
 * example, rule mutations that affect rule set size, like upgrading a rule,
 * should lead to cache invalidation.
 *
 * @returns A rules cache invalidation callback
 */
exports.useFetchPrebuiltRulesUpgradeReviewQuery = useFetchPrebuiltRulesUpgradeReviewQuery;
const useInvalidateFetchPrebuiltRulesUpgradeReviewQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(REVIEW_RULE_UPGRADE_QUERY_KEY, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFetchPrebuiltRulesUpgradeReviewQuery = useInvalidateFetchPrebuiltRulesUpgradeReviewQuery;