"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFetchPrebuiltRuleBaseVersionQuery = exports.useFetchPrebuiltRuleBaseVersionQuery = exports.GET_RULE_BASE_VERSION_QUERY_KEY = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _lodash = require("lodash");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _api = require("../../api");
var _urls = require("../../../../../../common/api/detection_engine/prebuilt_rules/urls");
var _constants = require("../constants");
var _retry_on_rate_limited_error = require("./retry_on_rate_limited_error");
var _capped_exponential_backoff = require("./capped_exponential_backoff");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GET_RULE_BASE_VERSION_QUERY_KEY = exports.GET_RULE_BASE_VERSION_QUERY_KEY = ['POST', _urls.GET_PREBUILT_RULES_BASE_VERSION_URL];
const useFetchPrebuiltRuleBaseVersionQuery = ({
  id,
  enabled
}, options) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useQuery)([...GET_RULE_BASE_VERSION_QUERY_KEY, id], async ({
    signal
  }) => {
    if (id) {
      return (0, _api.getPrebuiltRuleBaseVersion)({
        signal,
        request: {
          id
        }
      });
    }
    return null;
  }, {
    ..._constants.DEFAULT_QUERY_OPTIONS,
    ...options,
    enabled,
    onError: error => {
      const statusCode = (0, _lodash.get)(error, 'response.status');
      // If we cannot find the rule base version, we suppress the error and handle it internally
      if (statusCode === 404) {
        return;
      }
      addError(error, {
        title: i18n.FETCH_PREBUILT_RULE_BASE_VERSION_ERROR
      });
    },
    retry: _retry_on_rate_limited_error.retryOnRateLimitedError,
    retryDelay: _capped_exponential_backoff.cappedExponentialBackoff
  });
};
exports.useFetchPrebuiltRuleBaseVersionQuery = useFetchPrebuiltRuleBaseVersionQuery;
const useInvalidateFetchPrebuiltRuleBaseVersionQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(GET_RULE_BASE_VERSION_QUERY_KEY, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFetchPrebuiltRuleBaseVersionQuery = useInvalidateFetchPrebuiltRuleBaseVersionQuery;