"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFindBackfillQuery = exports.useFindBackfillsForRules = void 0;
var _reactQuery = require("@tanstack/react-query");
var _react = require("react");
var _api = require("../api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIND_BACKFILLS_FOR_RULES = 'FIND_BACKFILLS_FOR_RULES';
const useInvalidateFindBackfillQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries([FIND_BACKFILLS_FOR_RULES], {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFindBackfillQuery = useInvalidateFindBackfillQuery;
const useFindBackfillsForRules = ({
  ruleIds,
  page,
  perPage
}, options) => {
  return (0, _reactQuery.useQuery)([FIND_BACKFILLS_FOR_RULES, ...ruleIds, page, perPage], async ({
    signal
  }) => {
    const response = await (0, _api.findBackfillsForRules)({
      signal,
      ruleIds,
      page,
      perPage
    });
    return response;
  }, {
    retry: 0,
    keepPreviousData: true,
    ...options
  });
};
exports.useFindBackfillsForRules = useFindBackfillsForRules;